/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperException;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipesMassActionsService {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipesSaveService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.recipes.massactions");

    public InfoMessage.InfoMessages startSetImpalaWriteMode(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean any = false;
        boolean all = true;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                if (this.hasImpalaEngine(recipe, authCtx)) {
                    any = true;
                    continue;
                }
                all = false;
            }
            catch (Exception e) {
                logger.error((Object)"Faield to check Impala status", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!any) {
            ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "The specified recipes don't run on Impala");
        } else if (!all) {
            ret.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipes don't run on Impala, this will have no effect on them.");
        }
        return ret;
    }

    public InfoMessage.InfoMessages startSetHiveEngine(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean any = false;
        boolean all = true;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                if (this.hasHiveEngine(recipe, authCtx)) {
                    any = true;
                    continue;
                }
                all = false;
            }
            catch (Exception e) {
                logger.error((Object)"Faield to check Hive status", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!any) {
            ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "The specified recipes don't run on Hive");
        } else if (!all) {
            ret.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipes don't run on Hive, this will have no effect on them.");
        }
        return ret;
    }

    public InfoMessage.InfoMessages setImpalaWriteMode(Collection<TaggableObjectsService.TaggableObjectRef> refs, boolean runInStreamMode, AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                AnyLoc loc = ref.getLoc();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (this.hasImpalaEngine(sr, authCtx)) {
                    String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
                    logger.info((Object)("Setting Impala stream mode for recipe " + sr.getId()));
                    String newPayload = RecipeRegistry.getMeta(sr).setImpalaMode(sr, payload, runInStreamMode);
                    this.recipesDAO.save(sr.projectKey, sr.name, sr, newPayload);
                    continue;
                }
                logger.info((Object)("Recipe " + sr.getId() + " does not run on Impala. Skipping."));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to set Impala write mode", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return ret;
    }

    public InfoMessage.InfoMessages setHiveEngine(Collection<TaggableObjectsService.TaggableObjectRef> refs, HiveRecipeMeta.HiveExecutionEngine executionEngine, AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                AnyLoc loc = ref.getLoc();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (this.hasHiveEngine(sr, authCtx)) {
                    String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
                    logger.info((Object)("Setting Hive engine for recipe " + sr.getId()));
                    String newPayload = RecipeRegistry.getMeta(sr).setHiveEngine(sr, payload, executionEngine);
                    this.recipesDAO.save(sr.projectKey, sr.name, sr, newPayload);
                    continue;
                }
                logger.info((Object)("Recipe " + sr.getId() + " does not run on Hive. Skipping."));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to set Hive engine", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return ret;
    }

    public InfoMessage.InfoMessages startSetSparkConfig(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean any = false;
        boolean all = true;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                if (this.hasSparkEngine(recipe, authCtx)) {
                    any = true;
                    continue;
                }
                all = false;
            }
            catch (Exception e) {
                logger.error((Object)"Faield to check Spark status", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!any) {
            ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "The specified recipes don't run on Spark");
        } else if (!all) {
            ret.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipes don't run on Spark, this will have no effect on them.");
        }
        return ret;
    }

    public InfoMessage.InfoMessages setSparkConfig(List<TaggableObjectsService.TaggableObjectRef> refs, SparkOverrideConfig config, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            AnyLoc loc = ref.getLoc().resolved();
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
            String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
            if (this.hasSparkEngine(sr, authCtx)) {
                logger.info((Object)("Setting spark engine for recipe " + sr.getId()));
                String newPayload = RecipeRegistry.getMeta(sr).setSparkConf(sr, payload, config);
                this.recipesDAO.save(sr.projectKey, sr.name, sr, newPayload);
                continue;
            }
            logger.info((Object)("Recipe " + sr.getId() + " does not run on Spark. Skipping."));
        }
        return ret;
    }

    public InfoMessage.InfoMessages startSetSparkEngine(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean any = false;
        boolean all = true;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                if (this.hasSparkEngine(recipe, authCtx)) {
                    any = true;
                    continue;
                }
                all = false;
            }
            catch (Exception e) {
                logger.error((Object)"Faield to check Spark status", (Throwable)e);
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!any) {
            ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "The specified recipes don't run on Spark");
        } else if (!all) {
            ret.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipes don't run on Spark, this will have no effect on them.");
        }
        return ret;
    }

    public InfoMessage.InfoMessages setSparkEngine(List<TaggableObjectsService.TaggableObjectRef> refs, AbstractSparkRecipeParams.SparkExecutionEngine engine, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            AnyLoc loc = ref.getLoc().resolved();
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
            String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
            if (this.hasSparkEngine(sr, authCtx)) {
                logger.info((Object)("Setting spark engine for recipe " + sr.getId()));
                String newPayload = RecipeRegistry.getMeta(sr).setSparkEngine(sr, payload, engine);
                this.recipesDAO.save(sr.projectKey, sr.name, sr, newPayload);
                continue;
            }
            logger.info((Object)("Recipe " + sr.getId() + " does not run on Spark. Skipping."));
        }
        return ret;
    }

    public Object changeCodeEnv(List<TaggableObjectsService.TaggableObjectRef> refs, CodeEnvSelection envSelection) throws IOException, DKUSecurityException, CodedException {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            AnyLoc loc = ref.getLoc().resolved();
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
            RecipeMeta meta = RecipeRegistry.getMeta(sr);
            if (meta instanceof MetaWithSelectableCodeEnv) {
                logger.info((Object)("Change code env for " + sr.getFullId()));
                RecipeParams params = sr.getParamsAs(meta.paramsClass());
                ((ParamsWithSelectableCodeEnv)((Object)params)).setCodeEnvSelection(envSelection);
                this.recipesSaveService.save(ref.projectKey, sr, null);
                continue;
            }
            logger.info((Object)("Cannot change code env for " + sr.getFullId() + ". Skiping."));
        }
        return ret;
    }

    public InfoMessage.InfoMessages startSetPipelineability(List<TaggableObjectsService.TaggableObjectRef> refs, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        boolean any = false;
        boolean all = true;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            try {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
                if (new RecipePipelineHelperFactory(pipelineType).build(recipe, authCtx).canSetPipelineability()) {
                    any = true;
                    continue;
                }
                all = false;
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to check pipelineability for recipe %s", new Object[]{ref.getLoc().getFullName()});
                ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!any) {
            ret.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "The specified recipes are not pipelineable");
        } else if (!all) {
            ret.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipes are not pipelineable, this will have no effect on them.");
        }
        return ret;
    }

    public void setPipelineability(List<TaggableObjectsService.TaggableObjectRef> recipesRefs, RecipePipelineHelper.PipelineType pipelineType, boolean allowStart, boolean allowMerge, AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException, RecipePipelineHelperException {
        for (TaggableObjectsService.TaggableObjectRef ref : recipesRefs) {
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(ref.getLoc());
            String payload = new RecipePipelineHelperFactory(pipelineType).build(sr, authCtx).setPipelineability(allowStart, allowMerge);
            this.recipeSaveService.save(sr.projectKey, sr, payload);
        }
    }

    private boolean hasSparkEngine(SerializedRecipe recipe, AuthCtx authCtx) throws Exception {
        if (recipe.type.contains("spark")) {
            return true;
        }
        String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
        RecipeStatus status = RecipeRegistry.getMeta(recipe).buildStatusComputer(recipe, payload).fastStatusIgnorePartitions(authCtx);
        return "SPARK".equals(status.selectedEngine.type);
    }

    private boolean hasImpalaEngine(SerializedRecipe recipe, AuthCtx authCtx) throws Exception {
        if (ImpalaRecipeMeta.META.getType().equals(recipe.type)) {
            return true;
        }
        String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
        RecipeStatus status = RecipeRegistry.getMeta(recipe).buildStatusComputer(recipe, payload).fastStatusIgnorePartitions(authCtx);
        return "IMPALA".equals(status.selectedEngine.type);
    }

    private boolean hasHiveEngine(SerializedRecipe recipe, AuthCtx authCtx) throws Exception {
        if (HiveRecipeMeta.META.getType().equals(recipe.type)) {
            return true;
        }
        String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
        RecipeStatus status = RecipeRegistry.getMeta(recipe).buildStatusComputer(recipe, payload).fastStatusIgnorePartitions(authCtx);
        return "HIVE".equals(status.selectedEngine.type);
    }
}

