/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class SuspiciousMetricsMonitoringService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.metrics.monitor");

    private void checkAndLogIntGauge(Map<String, Metric> metrics, String name, int maxValue) {
        Metric gn = metrics.get(name);
        if (!(gn instanceof Gauge)) {
            logger.debug((Object)("Metric to monitor not found: name=" + name + " gn=" + String.valueOf(gn)));
            return;
        }
        Gauge gauge = (Gauge)gn;
        Object value = gauge.getValue();
        if (!(value instanceof Integer)) {
            logger.debug((Object)("Metric to monitor unexpected type: name=" + name + " gn=" + String.valueOf(gn)));
            return;
        }
        Integer intValue = (Integer)value;
        if (intValue > maxValue) {
            logger.info((Object)("High value for metric name=" + name + " value=" + intValue));
        } else {
            logger.trace(() -> "OK value for metric name=" + name + " value=" + intValue);
        }
    }

    private void checkAndLogLongCounter(Map<String, Metric> metrics, String name, long maxValue) {
        Metric gn = metrics.get(name);
        if (gn instanceof Counter) {
            Counter counter = (Counter)gn;
            long value = counter.getCount();
            if (value > maxValue) {
                logger.info((Object)("High value for metric name=" + name + " value=" + value));
            } else {
                logger.trace(() -> "OK value for metric  name=" + name + " value=" + value);
            }
        } else {
            logger.debug((Object)("Metric to monitor not found name=" + name + " gn=" + String.valueOf(gn)));
        }
    }

    void runCheck() {
        try {
            Map metrics = DSSMetrics.registry().getMetrics();
            logger.trace((Object)"Checking metrics");
            this.checkAndLogLongCounter(metrics, "dku.notifications.queue.size", 1000L);
            this.checkAndLogIntGauge(metrics, "dku.asynctasks.queue.size", 500);
            this.checkAndLogIntGauge(metrics, "dku.catalog.indexing.queue.internal-catalog.size", 1000);
            this.checkAndLogIntGauge(metrics, "dku.catalog.indexing.queue.external-catalog.size", 1000);
            this.checkAndLogIntGauge(metrics, "dku.catalog.indexing.bufferedQueue.internal-catalog.size", 10000);
            this.checkAndLogIntGauge(metrics, "dku.catalog.indexing.bufferedQueue.internal-columns.size", 50000);
            this.checkAndLogIntGauge(metrics, "dku.catalog.indexing.bufferedQueue.external-catalog.size", 10000);
        }
        catch (Exception e) {
            logger.error((Object)"Checking metrics failed", (Throwable)e);
        }
    }

    @PostConstruct
    public void start() {
        DKUtils.easyScheduleRecurring((String)"important-metrics-monitor", this::runCheck, (long)60000L);
    }
}

