/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.Latitude;
import com.dataiku.dip.shaker.types.Longitude;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class GeoPointExtractor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<GeoPointExtractor, Parameter> META = new ProcessorMeta<GeoPointExtractor, Parameter>(){

        @Override
        public String getName() {
            return "GeoPointExtractor";
        }

        @Override
        public String getDocPage() {
            return "geopoint-extract";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GeoPointExtractor.HELP", "This processor extracts two latitude and longitude columns from a column in GeoPoint format.\nGeoPoint is a data meaning representing a point on Earth. It supports several standard point representation formats.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GeoPointExtractor.DESCRIPTION", 1.actionVerb("Extract") + " lat/lon from GeoPoint"), true).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSOR.GeoPointExtractor.DESCRIPTION.COLUMN", "Input 'GeoPoint' column")).withParam("lat_col", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.GeoPointExtractor.DESCRIPTION.LAT_COL", "'Latitude' column")).withParam("lon_col", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.GeoPointExtractor.DESCRIPTION.LON_COL", "'Longitude' column"));
        }

        @Override
        public GeoPointExtractor build(Parameter parameter) {
            return new GeoPointExtractor(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter extractorParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)extractorParams.column)) {
                throw new IllegalConfigurationException("Missing geopoint column information for lineage on the geopoint lat/lon extractor processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Stream.of(extractorParams.lat_col, extractorParams.lon_col).filter(StringUtils::isNotBlank).forEach(col -> {
                    if (!Objects.equals(extractorParams.column, col)) {
                        updatedDatasetPairLineage.removeRelationsOnColumn((String)col);
                        updatedDatasetPairLineage.addFactorizedColumnRelations(extractorParams.column, (String)col);
                    }
                });
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private Parameter params;
    private Column outLonCol;
    private Column outLatCol;
    private Column inCol;

    public GeoPointExtractor(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.inCol = this.getColumnFactory().column(this.params.column, Processor.ProcessorRole.INPUT_COLUMN);
        if (!this.params.lon_col.isEmpty()) {
            this.outLonCol = this.getColumnFactory().columnAfter(this.params.column, this.params.lon_col, Processor.ProcessorRole.OUTPUT_COLUMN);
            if (this.outLonCol instanceof MemColumn) {
                ((MemColumn)this.outLonCol).forceType((MeaningDetector)new Longitude());
            }
        }
        if (!this.params.lat_col.isEmpty()) {
            this.outLatCol = this.getColumnFactory().columnAfter(this.params.column, this.params.lat_col, Processor.ProcessorRole.OUTPUT_COLUMN);
            if (this.outLatCol instanceof MemColumn) {
                ((MemColumn)this.outLatCol).forceType((MeaningDetector)new Latitude());
            }
        }
    }

    public void processRow(Row row) {
        GeoPoint.Coords coords;
        String str = row.get(this.inCol);
        if (str != null && (coords = GeoPoint.convert(str)) != null) {
            if (this.outLatCol != null) {
                row.put(this.outLatCol, coords.latitude);
            }
            if (this.outLonCol != null) {
                row.put(this.outLonCol, coords.longitude);
            }
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public String lat_col = "";
        public String lon_col = "";

        public void validate() throws IllegalArgumentException {
        }
    }
}

