/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.formats.JSONUtils;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Pivot
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<Pivot, Parameter> META = new ProcessorMeta<Pivot, Parameter>(){

        @Override
        public String getName() {
            return "Pivot";
        }

        @Override
        public String getDocPage() {
            return "pivot";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.Pivot.DESCRIPTION", 1.actionVerb("Pivot"))).withMNEColParam("indexColumn", this.translate(language, "SHAKER.PROCESSOR.Pivot.DESCRIPTION.INDEX_COLUMN", "Index column")).withMNEColParam("labelsColumn", this.translate(language, "SHAKER.PROCESSOR.Pivot.DESCRIPTION.LABELS_COLUMN", "Labels column")).withMNEColParam("valuesColumn", this.translate(language, "SHAKER.PROCESSOR.Pivot.DESCRIPTION.VALUES_COLUMN", "Values column")).withParam(ParamDesc.advancedSelect("otherColumnsAction", this.translate(language, "SHAKER.PROCESSOR.Pivot.DESCRIPTION.OTHER_COLUMNS", "Other columns"), "", OtherColumnsAction.class, language).withDefaultValue(OtherColumnsAction.KEEP_IF_CONSTANT));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"indexColumn", "labelsColumn", "valuesColumn"});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.Pivot.HELP", "Transpose multiple rows into columns, widening the dataset.\n\n<u>*Note*</u>\nBefore running a Pivot processor:\n- Sort the values of the index column so that identical values are adjacent. If the column is not sorted, the processor may create unneeded index rows.\n- Ensure the data source is not parallel (i.e. single-threaded, e.g. a single file)\n\n# Example\n\nInput:\n<table><tr><th>Company</th><th>Type</th><th>Value</th></tr><tr><td>Comp.A</td><td>Revenue</td><td>42M</td></tr><tr><td>Comp.A</td><td>Raw Margin</td><td>9M</td></tr><tr><td>Comp.B</td><td>Revenue</td><td>137M</td></tr><tr><td>Comp.B</td><td>Raw Margin</td><td>3M</td></tr><tr><td>Comp.B</td><td>Net income</td><td>-11M</td></tr></table>\nPivot with:\n* Index column: Company\n* Labels column: Type\n* Values column: Value\n\nResult:\n<table><tr><th>Company</th><th>Revenue</th><th>Raw Margin</th><th>Net income</th></tr><tr><td>Comp.A</td><td>42M</td><td>9M</td><td></td></tr><tr><td>Comp.B</td><td>137M</td><td>3M</td><td>-11M</td></tr></table>\n# Options\n\n**Index column**\nGenerate a new row for each change of value in the index column.\n**Labels column**\nCreate a column for each value in the label column.\n**Values column**\nPopulate cells with the values of the values column. When several rows have the same index and label, the pivot only keeps the value corresponding to the last row in the output.\n**Other columns**\nSelect how to populate the cells in the other columns:\n* Clear the cells\n* Keep only the first value\n* Retain the value if only one distinct value exists\n* Enclose all values in an array\nExample of OK input:\n```\n  idx1   label1   v1\n  idx1   label2   v2\n  idx2   label1   v3\n```\nExample of not OK input:\n```\n  idx1   label1   v1\n  idx2   label1   v3\n  idx1   label2   v2\n```\n**Related Resources**\nTo build pivot tables with more control over the rows, columns and aggregations, use the [Pivot recipe](https://doc.dataiku.com/dss/latest/other_recipes/pivot.html).");
        }

        @Override
        public Pivot build(Parameter parameter) throws Exception {
            return new Pivot(parameter);
        }
    };
    private Parameter parameter;
    private Column indexCD;
    private Column labelsCD;
    private Column valuesCD;
    private ArrayList<Column> otherCD = null;
    String curIdx;
    Map<String, String> curvals = new HashMap<String, String>();
    Map<String, String> othercols = new HashMap<String, String>();
    ArrayListMultimap<String, String> otherColVals = ArrayListMultimap.create();
    Set<String> otherColPresent = new HashSet<String>();

    public Pivot(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.indexCD = this.getCf().column(this.parameter.indexColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.labelsCD = this.getCf().column(this.parameter.labelsColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.valuesCD = this.getCf().column(this.parameter.valuesColumn, Processor.ProcessorRole.INPUT_COLUMN);
    }

    private void flush() throws Exception {
        if (this.curIdx == null) {
            return;
        }
        Row row = this.getRf().row();
        row.put(this.indexCD, this.curIdx);
        for (Map.Entry<String, String> e : this.curvals.entrySet()) {
            row.put(this.getCf().column(e.getKey()), e.getValue());
        }
        switch (this.parameter.otherColumnsAction) {
            case CLEAR: {
                break;
            }
            case KEEP_FIRST: 
            case KEEP_IF_CONSTANT: {
                for (Map.Entry<String, String> e : this.othercols.entrySet()) {
                    if (!this.otherColPresent.contains(e.getKey()) || e.getValue() == null) continue;
                    row.put(this.getCf().column(e.getKey(), Processor.ProcessorRole.OUTPUT_COLUMN), e.getValue());
                }
                this.othercols.clear();
                break;
            }
            case MAKE_ARRAY: {
                for (String col : this.otherColVals.keySet()) {
                    if (!this.otherColPresent.contains(col)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    for (String value : this.otherColVals.get((Object)col)) {
                        if (value == null) {
                            sb.append("\"\", ");
                            continue;
                        }
                        sb.append('\"');
                        JSONUtils.escapeJSONString(value, sb);
                        sb.append("\", ");
                    }
                    if (sb.length() > 2) {
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    row.put(this.getCf().column(col, Processor.ProcessorRole.OUTPUT_COLUMN), sb.toString());
                }
                this.otherColVals.clear();
            }
        }
        this.getProcessorOutput().emitRow(row);
        this.curIdx = null;
        this.curvals.clear();
        this.otherColPresent.clear();
    }

    public void processRow(Row row) throws Exception {
        String indexVal;
        if (this.otherCD == null) {
            this.otherCD = Lists.newArrayList((Iterable)this.getCf().columns());
            this.otherCD.remove(this.indexCD);
            this.otherCD.remove(this.labelsCD);
            this.otherCD.remove(this.valuesCD);
        }
        if ((indexVal = row.get(this.indexCD)) == null || indexVal.isEmpty()) {
            this.flush();
            return;
        }
        if (this.curIdx != null && !indexVal.equals(this.curIdx)) {
            this.flush();
        }
        this.curIdx = indexVal;
        String labelVal = row.get(this.labelsCD);
        if (labelVal == null || labelVal.isEmpty()) {
            return;
        }
        labelVal = labelVal.trim();
        String valueVal = row.get(this.valuesCD);
        this.curvals.put(labelVal, valueVal);
        if (this.parameter.otherColumnsAction != OtherColumnsAction.CLEAR) {
            for (Column c2 : this.otherCD) {
                String cell = row.get(c2);
                if (!StringUtils.isEmpty((String)cell)) {
                    this.otherColPresent.add(c2.getName());
                }
                switch (this.parameter.otherColumnsAction) {
                    case KEEP_FIRST: {
                        if (this.othercols.containsKey(c2.getName())) break;
                        this.othercols.put(c2.getName(), cell);
                        break;
                    }
                    case KEEP_IF_CONSTANT: {
                        if (this.othercols.containsKey(c2.getName())) {
                            if (cell != null && cell.equals(this.othercols.get(c2.getName()))) break;
                            this.othercols.put(c2.getName(), null);
                            break;
                        }
                        this.othercols.put(c2.getName(), cell);
                        break;
                    }
                    case MAKE_ARRAY: {
                        this.otherColVals.put((Object)c2.getName(), (Object)cell);
                        break;
                    }
                }
            }
        }
    }

    public void postProcess() throws Exception {
        this.flush();
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String indexColumn;
        String labelsColumn;
        String valuesColumn;
        OtherColumnsAction otherColumnsAction = OtherColumnsAction.CLEAR;

        public void validate() throws IllegalArgumentException {
        }
    }

    public static enum OtherColumnsAction implements Labelled
    {
        CLEAR("SHAKER.PROCESSOR.Pivot.OtherColumnsAction.CLEAR", "Clear"),
        KEEP_FIRST("SHAKER.PROCESSOR.Pivot.OtherColumnsAction.KEEP_FIRST", "Keep first value"),
        KEEP_IF_CONSTANT("SHAKER.PROCESSOR.Pivot.OtherColumnsAction.KEEP_IF_CONSTANT", "Keep if constant"),
        MAKE_ARRAY("SHAKER.PROCESSOR.Pivot.OtherColumnsAction.MAKE_ARRAY", "Make an array");

        public final String translationID;
        public final String enLabel;

        private OtherColumnsAction(String translationID, String enLabel) {
            this.translationID = translationID;
            this.enLabel = enLabel;
        }

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
            return ts.translateNoContext(language, this.translationID, this.enLabel, new Object[0]);
        }
    }
}

