/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class DateProcessor
extends SingleRowProcessor
implements Processor {

    public static abstract class DateProcessorMeta<T extends Processor, P extends DateParameter>
    extends ProcessorMeta<T, P> {
        public DatasetPairLineage getUpdatedDatasetPairLineage(StepParams param, DatasetPairLineage previousDatasetPairLineage, boolean overrideOutput) {
            if (!(param instanceof DateParameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + param.getClass().getSimpleName());
            }
            DateParameter parameter = (DateParameter)param;
            if (StringUtils.isBlank((String)parameter.inCol)) {
                throw new IllegalConfigurationException("Missing input column information for lineage on " + this.getName() + " processor parameters.");
            }
            DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage(previousDatasetPairLineage);
            if (!Objects.equals(parameter.outCol, parameter.inCol)) {
                if (overrideOutput) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(parameter.outCol);
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(parameter.inCol, parameter.outCol);
            }
            return updatedDatasetPairLineage;
        }
    }

    public static abstract class DateParameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inCol;
        public String outCol;

        public void validate() throws IllegalArgumentException {
        }
    }
}

