/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.resources;

import com.dataiku.dip.code.FixedPythonBinCodeEnvResolutionService;
import com.dataiku.dip.code.ICodeEnvResolutionService;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.mrimpl.ShakerJobConfigurator;
import com.dataiku.dip.util.PythonResourceUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class YarnPythonBinsSetup {
    public static final String PYTHON_PATH_IN_IMAGE_PREFIX = "spark.dku.pathInImage.python";
    public static final String REMOTE_DKU_PROJECT_KEY = "__dku_proj__";
    public static boolean isRemote = false;
    private static Logger logger = Logger.getLogger((String)"dip.shaker.yarn.python");

    private YarnPythonBinsSetup() {
    }

    public static Map<String, String> setupFromMapping(Map<String, String> resouceMapping) throws IOException {
        HashMap localResourceFiles = Maps.newHashMap();
        for (Map.Entry<String, String> e : resouceMapping.entrySet()) {
            localResourceFiles.put(e.getKey(), new File(".", e.getValue()));
        }
        return YarnPythonBinsSetup.setup(localResourceFiles);
    }

    public static Map<String, String> setup(Map<String, File> localResourceFiles) throws IOException {
        return YarnPythonBinsSetup.setup(localResourceFiles, Maps.newHashMap());
    }

    public static synchronized Map<String, String> setup(Map<String, File> localResourceFiles, Map<String, String> sparkConf) throws IOException {
        isRemote = true;
        HashMap pythonlibs = Maps.newHashMap();
        File yarnPythonBinsFile = localResourceFiles.get("dku.shaker.yarn.python.bins");
        if (yarnPythonBinsFile != null) {
            ShakerJobConfigurator.YarnPythonBinsDefinition yarnPythonBins = (ShakerJobConfigurator.YarnPythonBinsDefinition)JSON.parseFile((File)yarnPythonBinsFile, ShakerJobConfigurator.YarnPythonBinsDefinition.class);
            File pythonPathFile = new File("__dku_python_packages");
            pythonlibs.put("python-packages", pythonPathFile.getAbsolutePath());
            for (Map.Entry<String, String> entry : yarnPythonBins.pythonPachageZips.entrySet()) {
                String string = entry.getValue();
                File zipFile = localResourceFiles.get(PythonResourceUtils.getPackageKey(string));
                File packageFolder = new File(pythonPathFile, string);
                logger.info((Object)("Unzip " + zipFile.getAbsolutePath() + " to " + packageFolder.getAbsolutePath() + " (zip=" + entry.getKey() + " package=" + entry.getValue() + ")"));
                ZipUnzipDir.extractFolder(zipFile, packageFolder);
            }
            if (localResourceFiles.containsKey("instance-python-lib")) {
                YarnPythonBinsSetup.handlePythonLib(pythonlibs, localResourceFiles, "instance-python-lib", "__dku_instance_python_lib", "instance");
            }
            if (localResourceFiles.containsKey("project-python-lib")) {
                File projectLibFolderPath = new File("__dku_project_python_lib");
                File file = localResourceFiles.get("project-python-lib");
                YarnPythonBinsSetup.unzipToFolder(file, projectLibFolderPath, "project");
                File file2 = new File(projectLibFolderPath, "project-lib-paths.json");
                if (file2.exists()) {
                    ProjectLibPathHelper.ProjectLibsPaths plp = (ProjectLibPathHelper.ProjectLibsPaths)JSON.parseFile((File)file2, ProjectLibPathHelper.ProjectLibsPaths.class);
                    for (String projectLibName : plp.pythonPath) {
                        File projectLibFile = new File(projectLibFolderPath, projectLibName);
                        logger.info((Object)("Adding project lib " + String.valueOf(projectLibFile) + " to python libs"));
                        pythonlibs.put(projectLibName, projectLibFile.getAbsolutePath());
                    }
                } else {
                    logger.warn((Object)"'project-lib-paths.json' not found, skipping loading project libs");
                }
            }
            for (String string : localResourceFiles.keySet()) {
                if (!string.startsWith("python-lib-plugin-")) continue;
                YarnPythonBinsSetup.handlePythonLib(pythonlibs, localResourceFiles, string, "__dku_" + string.replace("-", "_"), "python plugin");
            }
            HashMap pythonOverrides = Maps.newHashMap();
            if (sparkConf != null) {
                for (Map.Entry<String, String> entry : sparkConf.entrySet()) {
                    if (PYTHON_PATH_IN_IMAGE_PREFIX.equals(entry.getKey())) {
                        pythonOverrides.put("__BUILTIN_ENV__", entry.getValue());
                        continue;
                    }
                    if (!entry.getKey().startsWith("spark.dku.pathInImage.python.")) continue;
                    String envName = entry.getKey().substring(PYTHON_PATH_IN_IMAGE_PREFIX.length() + 1);
                    pythonOverrides.put(envName, entry.getValue());
                }
                if (pythonOverrides.size() > 0) {
                    logger.info((Object)("Found overrides to the python binaries : " + JSON.json((Object)pythonOverrides)));
                }
            }
            String string = StringUtils.defaultIfBlank((String)((String)pythonOverrides.get("__BUILTIN_ENV__")), (String)yarnPythonBins.builtinYarnPythonBin);
            HashMap hashMap = Maps.newHashMap();
            for (Map.Entry<String, String> e : yarnPythonBins.yarnPythonBins.entrySet()) {
                hashMap.put(e.getKey(), pythonOverrides.getOrDefault(e.getKey(), e.getValue()));
            }
            if (SpringUtils.getInstance().hasBeanNames(ICodeEnvResolutionService.class)) {
                SpringUtils.getInstance();
                ICodeEnvResolutionService service = (ICodeEnvResolutionService)SpringUtils.getBean(ICodeEnvResolutionService.class);
                if (service instanceof FixedPythonBinCodeEnvResolutionService) {
                    ((FixedPythonBinCodeEnvResolutionService)service).addCodeEnvs(string, hashMap);
                } else {
                    logger.warn((Object)("Unexpected code env resolution service type, not updating: " + service.getClass().getCanonicalName()));
                }
            } else {
                FixedPythonBinCodeEnvResolutionService resolutionService = new FixedPythonBinCodeEnvResolutionService(string, hashMap);
                SpringUtils.getInstance().registerSingletonBean(ICodeEnvResolutionService.class, (Object)resolutionService);
            }
        }
        return pythonlibs;
    }

    private static void handlePythonLib(Map<String, String> pythonLibs, Map<String, File> localResourceFiles, String resourceFilesKey, String packageFolderName, String libType) throws IOException {
        File zipFile = localResourceFiles.get(resourceFilesKey);
        File packageFolder = new File(packageFolderName);
        YarnPythonBinsSetup.unzipToFolder(zipFile, packageFolder, libType);
        pythonLibs.put(resourceFilesKey, packageFolder.getAbsolutePath());
    }

    private static void unzipToFolder(File zipFile, File dstDir, String libType) throws IOException {
        if (dstDir.exists()) {
            logger.info((Object)("Already unzipped " + libType + " lib " + zipFile.getAbsolutePath() + " to " + dstDir.getAbsolutePath()));
        } else {
            logger.info((Object)("Unzip " + libType + " lib " + zipFile.getAbsolutePath() + " to " + dstDir.getAbsolutePath()));
            try {
                DKUFileUtils.mkdirs((File)dstDir);
                ZipUnzipDir.extractFolder(zipFile, dstDir);
            }
            catch (Exception e) {
                if (dstDir.isDirectory()) {
                    logger.warn((Object)("Deleting " + dstDir.getAbsolutePath() + " because unzip failed"));
                    DKUFileUtils.deleteDirectory((File)dstDir);
                }
                throw e;
            }
        }
    }
}

