/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.types.AbstractUDMDetector;
import java.util.Set;

public class ValueListUDMDetector
extends AbstractUDMDetector {
    private Set<String> values;

    public ValueListUDMDetector(UserDefinedMeaning udm) {
        super(udm);
        this.values = udm.getNormalizedValueSet();
    }

    @Override
    public UserDefinedMeaning getUdm() {
        return this.udm;
    }

    public double detects(String val) {
        if (val != null && this.values.contains(this.udm.normalizationMode.apply(val))) {
            return 0.7f;
        }
        return 0.0;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isTemporal() {
        return false;
    }

    public String getMeaningId() {
        return this.udm.id;
    }

    public long longValue(String val) {
        return 0L;
    }

    public double doubleValue(String val) {
        return 0.0;
    }

    public boolean validates(String val) {
        return this.detects(val) > 0.0;
    }
}

