/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLPreparedStatement;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLStatement;
import com.dataiku.dip.spark.sparksql.RemoteSparkSQLHandler;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class DkuSparkSQLConnection
implements Connection {
    private final String database;
    private final int fetchSize;
    private final RemoteSparkSQLHandler sparkSQLHandler;
    private boolean isClosed;
    private static Logger logger = Logger.getLogger((String)"dip.livy.connection");

    public DkuSparkSQLConnection(RemoteSparkSQLHandler sparkSQLHandler, String database, int fetchSize) throws Exception {
        this.sparkSQLHandler = sparkSQLHandler;
        this.database = database;
        this.fetchSize = fetchSize;
        this.isClosed = false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                this.sparkSQLHandler.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close sparksql handler", (Throwable)e);
            }
        }
    }

    public RemoteSparkSQLHandler getSparkSQLHandler() {
        return this.sparkSQLHandler;
    }

    String getDatabase() {
        return this.database;
    }

    public void checkHealth() throws SQLException {
        logger.info((Object)"Ping remote spark session");
        try {
            logger.info((Object)("Got " + this.sparkSQLHandler.ping()));
        }
        catch (Exception e) {
            throw new SQLException("Remote spark session didn't respond", e);
        }
    }

    public void registerDataset(AuthCtx authCtx, HadoopSettings hadoopSettings, String datasetFullName, String tableName) throws SQLException {
        this.registerDataset(authCtx, hadoopSettings, datasetFullName, tableName, null);
    }

    public void registerDataset(AuthCtx authCtx, HadoopSettings hadoopSettings, String datasetFullName, String tableName, String partitionId) throws SQLException {
        logger.info((Object)("Register " + datasetFullName + " as " + tableName));
        try {
            SparkJobExecEnv datasetEnv = new SparkJobExecEnv();
            datasetEnv.fillInBackendOrJEK(Lists.newArrayList((Object[])new String[]{DatasetLocUtils.DatasetLoc.resolveFull(datasetFullName).getProjectKey()}), authCtx, null, hadoopSettings, false);
            logger.info((Object)("Got " + this.sparkSQLHandler.registerDataset(this.database, datasetFullName, tableName, datasetEnv, partitionId)));
        }
        catch (Exception e) {
            throw new SQLException("Remote spark session didn't respond", e);
        }
    }

    public DkuSparkSQLStatement executeQueryAndScript(String query, List<ScriptStep> scriptSteps, Schema scriptOutputSchema, String reportLocation) throws SQLException {
        DkuSparkSQLStatement statement = new DkuSparkSQLStatement(this, this.fetchSize);
        statement.doExecuteAndScript(query, scriptSteps, scriptOutputSchema, reportLocation);
        return statement;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DkuSparkSQLStatement(this, this.fetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DkuSparkSQLPreparedStatement(this, this.fetchSize, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }
}

