/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TeradataTz {
    public static final ImmutableMap<String, String> JAVA_TZ_TO_TERADATA_TZ = TeradataTz.fetchJavaTzToTeradataTz();
    private static Logger logger = Logger.getLogger((String)"dip.sql.teradata.tz");

    private static ImmutableMap<String, String> fetchJavaTzToTeradataTz() {
        String csv;
        TreeMap javaTzGroups = Maps.newTreeMap();
        for (String javaTzId : TimeZone.getAvailableIDs()) {
            boolean dst;
            TimeZone javaTz = TimeZone.getTimeZone(javaTzId);
            int offset = javaTz.getRawOffset() / 60000;
            String key = offset + " " + (dst = javaTz.useDaylightTime());
            if (!javaTzGroups.containsKey(key)) {
                javaTzGroups.put(key, new ArrayList());
            }
            ((List)javaTzGroups.get(key)).add(javaTzId);
        }
        try {
            csv = IOUtils.toString((InputStream)TeradataTz.class.getResourceAsStream("teradata_time_zones_specs.csv"));
        }
        catch (IOException e) {
            logger.error((Object)"Unable to load time zones specs", (Throwable)e);
            csv = "";
        }
        TreeMap teradataTzGroups = Maps.newTreeMap();
        try {
            for (String line : csv.split("\n")) {
                boolean dst;
                String[] elems = line.split(";");
                String tzId = elems[0];
                int offset = Integer.parseInt(elems[1]);
                String key = offset + " " + (dst = Boolean.parseBoolean(elems[2]));
                if (!teradataTzGroups.containsKey(key)) {
                    teradataTzGroups.put(key, new ArrayList());
                }
                ((List)teradataTzGroups.get(key)).add(tzId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to read specs", (Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry e : javaTzGroups.entrySet()) {
            String key = (String)e.getKey();
            if (!teradataTzGroups.containsKey(key)) continue;
            String teradataTz = (String)((List)teradataTzGroups.get(key)).get(0);
            for (String javaTz : (List)e.getValue()) {
                result.put(javaTz, teradataTz);
            }
        }
        return ImmutableMap.copyOf(result);
    }
}

