/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.metadata;

import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class DatabaseObjectKey {
    private static final String KEY_DELIMITER = "$%^";
    public final String connectionName;
    public final String catalog;
    public final String schema;
    public final String name;

    public String toKey() {
        return StringUtils.join(Arrays.asList(this.connectionName, this.catalog, this.schema, this.name), (String)KEY_DELIMITER);
    }

    public DatabaseObjectKey(String connectionName, String catalog, String schema, String name) {
        this.connectionName = connectionName;
        this.name = name;
        this.catalog = StringUtils.defaultIfEmpty((String)catalog, null);
        this.schema = schema;
    }

    public DatabaseObjectKey(AbstractSQLDatasetHandler.AbstractSQLConfig config) {
        this(config.getConnection(), config.catalog, config.schema, config.table);
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseObjectKey key = (DatabaseObjectKey)o;
        return Objects.equals(this.connectionName, key.connectionName) && Objects.equals(this.catalog, key.catalog) && Objects.equals(this.schema, key.schema) && Objects.equals(this.name, key.name);
    }

    public int hashCode() {
        return Objects.hash(this.connectionName, this.schema, this.catalog, this.name);
    }

    public String toString() {
        return this.toKey();
    }
}

