/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.streaming.endpoints.httpsse.SSEDecoder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.ConnectionClosedException;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TrivialSSEClient {
    private final String url;
    private final List<SimpleKeyValue> headers;
    private final RedirectStrategy redirectStrategy;
    private volatile boolean interrupted;
    private CloseableHttpClient client;
    private HttpGet get;
    private CloseableHttpResponse resp;
    private SSEDecoder decoder;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.sseclient");

    public TrivialSSEClient(String url, List<SimpleKeyValue> headers) {
        this(url, headers, null);
    }

    public TrivialSSEClient(String url, List<SimpleKeyValue> headers, RedirectStrategy redirectStrategy) {
        this.url = url;
        this.headers = headers;
        this.redirectStrategy = redirectStrategy;
    }

    public void interrupt() {
        this.interrupted = true;
        if (this.decoder != null) {
            this.decoder.interrupt();
        }
    }

    public void init(String previousState) throws IOException {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            if (this.redirectStrategy != null) {
                httpClientBuilder.setRedirectStrategy(this.redirectStrategy);
            }
            this.client = httpClientBuilder.build();
            this.get = new HttpGet(this.url);
            this.get.addHeader("Accept", "text/event-stream");
            for (SimpleKeyValue header : this.headers) {
                if (!StringUtils.isNotBlank((String)header.key)) continue;
                this.get.addHeader(header.key, StringUtils.defaultIfEmpty((String)header.value, (String)""));
            }
            if (StringUtils.isNotBlank((String)previousState)) {
                this.get.addHeader("Last-Event-ID", previousState);
            }
            this.resp = this.client.execute((HttpUriRequest)this.get);
            if (this.resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Request failed: " + this.resp.getStatusLine().getStatusCode());
            }
            this.decoder = new SSEDecoder(this.resp.getEntity().getContent());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to init httpsseclient", (Throwable)e);
            this.close();
        }
    }

    public void close() throws IOException {
        IOException last = null;
        if (this.get != null) {
            this.get.abort();
        }
        if (this.decoder != null) {
            try {
                this.decoder.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close httpsse client", (Throwable)e);
                last = e;
            }
        }
        if (this.resp != null) {
            try {
                this.resp.close();
            }
            catch (ConnectionClosedException e) {
                logger.info((Object)"Connection is closed");
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close httpsse client", (Throwable)e);
                last = e;
            }
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (ConnectionClosedException e) {
                logger.info((Object)"Connection is closed");
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close httpsse client", (Throwable)e);
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
    }

    public SSEDecoder.HTTPSSEEvent next() throws IOException {
        return this.decoder.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String previousState, EventSourceConsumer consumer) throws Exception {
        this.init(previousState);
        try {
            while (!this.interrupted) {
                SSEDecoder.HTTPSSEEvent evt = this.next();
                if (evt == null) {
                    logger.info((Object)"Event stream finished");
                    break;
                }
                consumer.process(evt);
            }
        }
        finally {
            this.close();
        }
    }

    public static interface EventSourceConsumer {
        public void process(SSEDecoder.HTTPSSEEvent var1) throws Exception;
    }
}

