/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatSerializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatsFactory;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ToSQSStreamer
implements StreamingEndpointSimpleWriter {
    private final AuthCtx authCtx;
    private final SQSStreamingEndpointParams seParams;
    private final SQSFormatSerializer serializer;
    private final ColumnFactory cf;
    private final StreamingEndpoint streamingEndpoint;
    private SQSConnection conn;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    public long writtenRows;
    private SqsClient client;
    private String queueUrl;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.sqs.writer");

    public ToSQSStreamer(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, ColumnFactory cf, WarningsContext warningsContext) throws Exception {
        this.authCtx = authCtx;
        this.streamingEndpoint = streamingEndpoint;
        this.cf = cf;
        this.seParams = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, SQSStreamingEndpointParams.class);
        this.serializer = SQSFormatsFactory.getSerializer(this.seParams);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void init() throws Exception {
        this.serializer.init(this.cf, this.streamingEndpoint.schema);
        this.conn = (SQSConnection)this.connectionsDAO.getConnection(this.authCtx, this.seParams.connection);
        this.client = this.conn.getSQSClient(this.authCtx);
        logger.info((Object)"Finding queue url");
        GetQueueUrlResponse getRes = this.client.getQueueUrl(builder -> builder.queueName(this.seParams.queueName));
        this.queueUrl = getRes.queueUrl();
        if (this.queueUrl == null) {
            throw new Exception("Unable to find queue with given credentials");
        }
    }

    public void processRow(Row row) throws Exception {
        String body;
        if (logger.isTraceEnabled()) {
            logger.traceV("Serializing record queueName=%s data=%s", new Object[]{this.seParams.queueName, row});
        }
        if ((body = this.serializer.serialize(row)) == null) {
            logger.info((Object)"Missing message, not sending");
            return;
        }
        SendMessageRequest.Builder reqBuilder = SendMessageRequest.builder().queueUrl(this.queueUrl).messageBody(body);
        if (this.seParams.queueName.endsWith(".fifo")) {
            String messageGroupId = row.get(this.cf.column(this.seParams.messageGroupIdColumn));
            if (StringUtils.isBlank((String)messageGroupId)) {
                messageGroupId = "streamed-from-dss";
            }
            reqBuilder.messageGroupId(messageGroupId);
            if (StringUtils.isNotBlank((String)this.seParams.deduplicationIdColumn)) {
                String deduplicationId = row.get(this.cf.column(this.seParams.deduplicationIdColumn));
                reqBuilder.messageDeduplicationId(StringUtils.defaultIfEmpty((String)deduplicationId, (String)""));
            }
        }
        SendMessageResponse res = this.client.sendMessage((SendMessageRequest)reqBuilder.build());
        logger.trace(() -> "Sent " + res.messageId());
        ++this.writtenRows;
        if (this.writtenRows % 10000L == 0L) {
            logger.info((Object)("Emitted " + this.writtenRows + " rows"));
        }
    }

    public void postProcess() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    public void setFactories(ColumnFactory cf, RowFactory rf) {
    }

    public void cancel() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

