/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.timelines.workspace.AbstractWorkspaceTimelinesService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineBehavior;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineInternalDB;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class MultiWorkspaceTimelinesInternalDB
extends AbstractWorkspaceTimelinesService {
    private static final Map<String, WorkspaceTimelineInternalDB> workspaceDAOs = new ConcurrentHashMap<String, WorkspaceTimelineInternalDB>();
    private static final AtomicLong timelinesInitTime = new AtomicLong(0L);
    private static final AtomicLong initializedTimelines = new AtomicLong(0L);
    private final Striped<Lock> locks = Striped.lock((int)100);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines.workspace");

    @Override
    public DSSDBConnection acquireConnection(String workspaceKey, boolean isReadOnly) throws CodedSQLException {
        return this.getWorkspaceDao(workspaceKey).acquireConnection(isReadOnly);
    }

    @Override
    public void createWorkspace(String workspaceKey) throws CodedSQLException {
        this.getDao(workspaceKey);
    }

    static File getWorkspaceDAOFile(String workspaceKey) {
        return new File(ApplicationConfigurator.getBaseFolderF(), "timelines/workspace." + workspaceKey);
    }

    @Override
    public void deleteForWorkspace(String workspaceKey) {
        try {
            this.getWorkspaceDao(workspaceKey).deleteConnectionPool();
        }
        catch (CodedSQLException e) {
            logger.errorV((Throwable)e, "Could not delete connections pool for %s", new Object[]{workspaceKey});
        }
        workspaceDAOs.remove(workspaceKey);
        try {
            File pageStoreFile = new File(String.valueOf(MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey).getAbsoluteFile()) + ".h2.db");
            File mvStoreFile = new File(String.valueOf(MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey).getAbsoluteFile()) + ".mv.db");
            if (pageStoreFile.exists()) {
                DKUFileUtils.forceDelete((File)pageStoreFile);
            } else if (mvStoreFile.exists()) {
                DKUFileUtils.forceDelete((File)mvStoreFile);
            } else {
                logger.warn((Object)"Timelines db not backed by a file with expected extension, or missing.");
            }
            if (MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey).exists()) {
                throw new RuntimeException("Workspace timeline file still exists");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete workspace timeline file: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            DKUFileUtils.forceDelete((File)new File(String.valueOf(MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey).getAbsoluteFile()) + ".trace.db"));
            if (MultiWorkspaceTimelinesInternalDB.getWorkspaceDAOFile(workspaceKey).exists()) {
                throw new RuntimeException("Workspace timeline file still exists");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete workspace timeline file: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    @Override
    public WorkspaceTimelineBehavior getDao(String workspaceKey) throws CodedSQLException {
        return this.getWorkspaceDao((String)workspaceKey).behavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkspaceTimelineInternalDB getWorkspaceDao(String workspaceKey) throws CodedSQLException {
        Lock l = (Lock)this.locks.get((Object)workspaceKey);
        l.lock();
        try {
            if (workspaceDAOs.containsKey(workspaceKey)) {
                WorkspaceTimelineInternalDB workspaceTimelineInternalDB = workspaceDAOs.get(workspaceKey);
                return workspaceTimelineInternalDB;
            }
            long count = initializedTimelines.incrementAndGet();
            Stopwatch sw = Stopwatch.createStarted();
            logger.info((Object)("Create timelines for workspace " + workspaceKey));
            WorkspaceTimelineInternalDB dao = new WorkspaceTimelineInternalDB(workspaceKey);
            dao.create();
            try (DSSDBConnection connection = dao.acquireConnection();){
                dao.behavior.fetchInitialUIData(connection);
            }
            workspaceDAOs.put(workspaceKey, dao);
            long time = timelinesInitTime.addAndGet(sw.elapsed(TimeUnit.MILLISECONDS));
            logger.info((Object)("Timelines init time: " + time + "ms (" + count + " timelines)"));
            WorkspaceTimelineInternalDB workspaceTimelineInternalDB = dao;
            return workspaceTimelineInternalDB;
        }
        finally {
            l.unlock();
        }
    }
}

