/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.DKUApp;
import java.io.File;

public class UnifiedMonitoringPaths {
    public static final String UNIFIED_MONITORING_PRESERVE_DATA_ON_STARTUP_FEATURE_FLAG = "unifiedMonitoring.preserveDataOnStartup";
    public static final String UNIFIED_MONITORING_PATH = "unified-monitoring";
    public static final String DEPLOYER_PATH = "unified-monitoring/deployer";
    public static final String API_DEPLOYER_BASE_FOLDER_PATH = "unified-monitoring/deployer/api-deployer";
    public static final String PROJECT_DEPLOYER_BASE_FOLDER_PATH = "unified-monitoring/deployer/project-deployer";
    public static final String EXTERNAL_ENDPOINTS_BASE_FOLDER_PATH = "unified-monitoring/deployer/external-endpoints";
    public static final String ALERTING_BASE_FOLDER_PATH = "unified-monitoring/deployer/alerting";
    public static final String DESIGN_PATH = "unified-monitoring/design";
    public static final String AUTOMATION_PATH = "unified-monitoring/automation";

    private UnifiedMonitoringPaths() {
        throw new IllegalStateException("Utility class, Sonar requires a private constructor");
    }

    public static File getSavedModelVersionBaseDir(String projectKey, String savedModelVersionId, File unifiedMonitoringBaseDir) {
        return DKUApp.getFile((File)unifiedMonitoringBaseDir, (String[])new String[]{projectKey, "models", savedModelVersionId});
    }

    public static File getMesMonitoring(String projectKey, String savedModelVersionId, String mesId, File unifiedMonitoringBaseDir) {
        return DKUApp.getFile((File)UnifiedMonitoringPaths.getSavedModelVersionBaseDir(projectKey, savedModelVersionId, unifiedMonitoringBaseDir), (String[])new String[]{mesId + ".json"});
    }

    public static File getApiDeployerEndpointsBaseDir(String deploymentId) {
        return DKUApp.getFile((String[])new String[]{API_DEPLOYER_BASE_FOLDER_PATH, "deployments", deploymentId});
    }

    public static File getProjectDeployerDeploymentsBaseDir() {
        return DKUApp.getFile((String[])new String[]{PROJECT_DEPLOYER_BASE_FOLDER_PATH, "deployments"});
    }

    public static File getProjectDeployerDeployment(String deploymentId) {
        return DKUApp.getFile((File)UnifiedMonitoringPaths.getProjectDeployerDeploymentsBaseDir(), (String[])new String[]{deploymentId + ".json"});
    }

    public static File getExternalEndpointsDeploymentsBaseDir(String externalEndpointsScopeName) {
        return DKUApp.getFile((String[])new String[]{EXTERNAL_ENDPOINTS_BASE_FOLDER_PATH, externalEndpointsScopeName});
    }

    public static File getExternalEndpointMonitoring(String externalEndpointsScopeName, String endpointName) {
        return DKUApp.getFile((String[])new String[]{EXTERNAL_ENDPOINTS_BASE_FOLDER_PATH, externalEndpointsScopeName, endpointName + ".json"});
    }

    public static File getAlertRunsInfo(String alertConfigId) {
        return DKUApp.getFile((String[])new String[]{ALERTING_BASE_FOLDER_PATH, alertConfigId + ".json"});
    }

    public static File getDesignBaseDir() {
        return DKUApp.getFile((String)DESIGN_PATH);
    }

    public static File getCachedProxyModelVersionsList() {
        return DKUApp.getFile((String[])new String[]{DESIGN_PATH, "proxy_models.json"});
    }

    public static File getAutomationBaseDir() {
        return DKUApp.getFile((String)AUTOMATION_PATH);
    }

    public static File getDeployedProjectStatuses(String deployedProjectKey) {
        return DKUApp.getFile((String[])new String[]{AUTOMATION_PATH, deployedProjectKey});
    }
}

