/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.MesChecksDeletedEvent;
import com.dataiku.dip.server.notifications.backend.MesChecksRunCompletedEvent;
import com.dataiku.dip.server.notifications.backend.MesRenamedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionDeletedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.unifiedmonitoring.AbstractUnifiedMonitoringQueueHandler;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDesignComputationService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringModelStatusComputationService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnifiedMonitoringQueueHandler
extends AbstractUnifiedMonitoringQueueHandler {
    @Autowired
    UnifiedMonitoringDesignComputationService unifiedMonitoringDesignComputationService;
    @Autowired
    UnifiedMonitoringModelStatusComputationService unifiedMonitoringModelStatusComputationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringQueueHandler");

    @Override
    public void run() {
        if ("deployer".equals(DKUApp.getInstallNodeType())) {
            return;
        }
        Thread.currentThread().setName("unified-monitoring-queue-handler");
        super.run();
    }

    @Override
    public void handleQueueEvent(BackendEvent event) {
        try {
            switch (event.getName()) {
                case "mes-checks-run-completed": {
                    this.handleMesChecksRunCompletedEvent((MesChecksRunCompletedEvent)event);
                    break;
                }
                case "mes-checks-deleted": {
                    this.handleMesChecksDeletedEvent((MesChecksDeletedEvent)event);
                    break;
                }
                case "object-change": {
                    this.handleTaggableObjectChangedEvent((TaggableObjectChangedEvent)event);
                    break;
                }
                case "model-version-deleted": {
                    this.handleProxyModelVersionDeletedEvent((ModelVersionDeletedEvent)event);
                    break;
                }
                case "mes-renamed-event": {
                    this.handleMesRenamedEvent((MesRenamedEvent)event);
                    break;
                }
                default: {
                    logger.infoV("Ignoring invalid event type: %s", new Object[]{event.getName()});
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while handling event %s", new Object[]{event.getName()});
        }
    }

    private void handleMesChecksRunCompletedEvent(MesChecksRunCompletedEvent event) throws Exception {
        logger.infoV("Handling event of type %s", new Object[]{event.getName()});
        FullModelEvaluationId fullModelEvaluationId = new FullModelEvaluationId(event.projectKey, event.mesId, event.modelEvaluationId);
        FullModelId fullModelId = fullModelEvaluationId.getUnderlyingModel();
        this.unifiedMonitoringModelStatusComputationService.updateOrCreateMesMonitoringStatus(event.projectKey, event.mesId, fullModelId, event.checkResults, event.timestamp);
    }

    private void handleMesChecksDeletedEvent(MesChecksDeletedEvent event) throws IOException {
        logger.infoV("Handling event of type %s", new Object[]{event.getName()});
        this.unifiedMonitoringModelStatusComputationService.deleteChecksFromMonitorings(event.projectKey, event.mesId, event.checkLabels);
    }

    private void handleTaggableObjectChangedEvent(TaggableObjectChangedEvent event) throws IOException {
        logger.infoV("Handling event of type %s", new Object[]{event.getName()});
        if (event.objectType == ITaggingService.TaggableType.SAVED_MODEL && event.details.getAsJsonPrimitive("savedModelType") != null && event.details.getAsJsonPrimitive("savedModelType").getAsString().equals(SavedModel.SavedModelType.PROXY_MODEL.toString())) {
            this.handleProxyModelChangedEvent(event);
        } else if (event.objectType == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            this.handleModelEvaluationStoreChangedEvent(event);
        }
    }

    private void handleProxyModelVersionDeletedEvent(ModelVersionDeletedEvent event) throws IOException {
        logger.infoV("Handling event of type %s", new Object[]{event.getName()});
        FullModelId fmi = FullModelId.parse(event.fullModelId);
        this.unifiedMonitoringDesignComputationService.deleteProxyModelVersionListing(fmi);
    }

    private void handleProxyModelChangedEvent(TaggableObjectChangedEvent event) throws IOException {
        if (event.action == TaggableObjectChangedEvent.ActionType.SAVED_MODEL_CREATE || event.action == TaggableObjectChangedEvent.ActionType.SAVED_MODEL_EDIT || event.action == TaggableObjectChangedEvent.ActionType.SAVED_MODEL_DELETE) {
            this.unifiedMonitoringDesignComputationService.updateProxyModelListing(event.projectKey, event.objectId);
        }
    }

    private void handleModelEvaluationStoreChangedEvent(TaggableObjectChangedEvent event) throws IOException {
        if (event.action == TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_DELETE) {
            this.unifiedMonitoringModelStatusComputationService.purgeMesFromModelStatuses(event.objectId);
        }
    }

    private void handleMesRenamedEvent(MesRenamedEvent event) throws IOException {
        logger.infoV("Handling event of type %s", new Object[]{event.getName()});
        this.unifiedMonitoringModelStatusComputationService.updateMesDisplayNameInModelStatuses(event.mesId, event.mesDisplayName);
    }
}

