/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.connections.CassandraUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class CassandraV1Query {
    CassandraUtil.ClusterConnection dbConn;
    String table;
    Set<String> fields;
    String filterColumn;
    String filterValue;
    int spreadValue;
    long maxRecords;
    int fetchSize;
    List<ColumnMetadata> partitionColumns;
    List<ColumnMetadata> clusterColumns;
    List<ClusteringOrder> clusteringOrder;
    boolean partitionKeyFilter;
    boolean clusterKeyFilter;
    StringBuilder initialQuery;
    StringBuilder afterRowQuery;
    StringBuilder[] afterColQuery;
    ArrayList<String> initialVariables;
    ArrayList<String> afterRowVariables;
    ArrayList<ArrayList<String>> afterColVariables;
    PreparedStatement initialPS;
    PreparedStatement afterRowPS;
    PreparedStatement[] afterColPS;
    int nCols;
    ResultSet rs;
    long nRows;
    Row lastRow;
    long totalRows;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.cassandra.v1");

    private PreparedStatement prepare(StringBuilder q) {
        logger.debug((Object)("Preparing query: " + String.valueOf(q)));
        return this.dbConn.prepare(q.toString());
    }

    private BoundStatement bindValues(PreparedStatement ps2, ArrayList<String> variables) {
        BoundStatement st2 = ps2.bind();
        assert (ps2.getVariables().size() == variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            String colName = variables.get(i);
            if (colName.equals(this.filterColumn)) {
                CassandraUtil.setCassandraValue(st2, i, this.filterValue);
                continue;
            }
            if (colName.equals("_dssSpread")) {
                st2.setInt(i, this.spreadValue);
                continue;
            }
            st2.setBytesUnsafe(i, this.lastRow.getBytesUnsafe(CassandraUtil.forceQuote(variables.get(i))));
        }
        return st2;
    }

    public CassandraV1Query(CassandraUtil.ClusterConnection dbConn, String table, int fetchSizeParam, Set<String> fields, String filterColumn, String filterValue, int spreadValue, long maxRecords) {
        int i;
        this.dbConn = dbConn;
        this.table = table;
        this.fields = fields;
        this.filterColumn = filterColumn;
        this.filterValue = filterValue;
        this.spreadValue = spreadValue;
        this.maxRecords = maxRecords;
        int n = this.fetchSize = fetchSizeParam > 0 ? fetchSizeParam : 5000;
        if (maxRecords > 0L && maxRecords < (long)this.fetchSize) {
            this.fetchSize = (int)maxRecords;
        }
        TableMetadata meta = dbConn.getKeyspaceMetadata().getTable(CassandraUtil.quote(table));
        this.partitionColumns = meta.getPartitionKey();
        this.clusterColumns = meta.getClusteringColumns();
        this.clusteringOrder = meta.getClusteringOrder();
        if (filterColumn != null) {
            if (this.partitionColumns.size() == 1 && filterColumn.equals(this.partitionColumns.get(0).getName()) && spreadValue < 0) {
                this.partitionKeyFilter = true;
            } else if (this.partitionColumns.size() == 2 && filterColumn.equals(this.partitionColumns.get(0).getName()) && "_dssSpread".equals(this.partitionColumns.get(1).getName()) && spreadValue >= 0) {
                this.partitionKeyFilter = true;
            } else if (this.clusterColumns.size() > 0 && filterColumn.equals(this.clusterColumns.get(0).getName())) {
                this.clusterKeyFilter = true;
            } else {
                for (ColumnMetadata col : meta.getPrimaryKey()) {
                    if (!filterColumn.equals(col.getName())) continue;
                    throw ErrorContext.iaef((String)"filtering column not supported for enumeration: %s", (Object)filterColumn, (Object[])new Object[0]);
                }
            }
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        if (fields == null) {
            prefix.append("*");
        } else {
            int fieldNum = 0;
            for (String f : fields) {
                if (fieldNum++ > 0) {
                    prefix.append(",");
                }
                prefix.append(CassandraUtil.quote(f));
            }
            for (ColumnMetadata col : meta.getPrimaryKey()) {
                String colName = col.getName();
                if (fields.contains(colName)) continue;
                if (fieldNum++ > 0) {
                    prefix.append(",");
                }
                prefix.append(CassandraUtil.quote(colName));
            }
        }
        prefix.append(" FROM " + CassandraUtil.quote(table));
        this.initialQuery = new StringBuilder(prefix);
        this.initialVariables = new ArrayList();
        this.afterRowQuery = new StringBuilder(prefix);
        this.afterRowVariables = new ArrayList();
        this.afterColQuery = new StringBuilder[this.clusterColumns.size()];
        this.afterColVariables = new ArrayList();
        for (int i2 = 0; i2 < this.clusterColumns.size(); ++i2) {
            this.afterColQuery[i2] = new StringBuilder(prefix);
            this.afterColVariables.add(new ArrayList());
        }
        if (this.partitionKeyFilter) {
            String filterString = " WHERE " + CassandraUtil.quote(filterColumn) + "=?";
            if (spreadValue >= 0) {
                filterString = filterString + " AND " + CassandraUtil.quote("_dssSpread") + "=?";
            }
            this.initialQuery.append(filterString);
            this.initialVariables.add(filterColumn);
            if (spreadValue >= 0) {
                this.initialVariables.add("_dssSpread");
            }
            this.afterRowQuery.append(filterString);
            this.afterRowVariables.add(filterColumn);
            if (spreadValue >= 0) {
                this.afterRowVariables.add("_dssSpread");
            }
            for (int i3 = 0; i3 < this.afterColQuery.length; ++i3) {
                this.afterColQuery[i3].append(filterString);
                this.afterColVariables.get(i3).add(filterColumn);
                if (spreadValue < 0) continue;
                this.afterColVariables.get(i3).add("_dssSpread");
            }
        } else {
            int i4;
            StringBuilder partColNames = new StringBuilder("token(");
            StringBuilder partColValues = new StringBuilder("token(");
            ArrayList<String> partColVariables = new ArrayList<String>();
            for (i4 = 0; i4 < this.partitionColumns.size(); ++i4) {
                if (i4 > 0) {
                    partColNames.append(",");
                    partColValues.append(",");
                }
                partColNames.append(CassandraUtil.quote(this.partitionColumns.get(i4).getName()));
                partColValues.append("?");
                partColVariables.add(this.partitionColumns.get(i4).getName());
            }
            partColNames.append(")");
            partColValues.append(")");
            this.afterRowQuery.append(" WHERE " + String.valueOf(partColNames) + ">" + String.valueOf(partColValues));
            this.afterRowVariables.addAll(partColVariables);
            for (i4 = 0; i4 < this.clusterColumns.size(); ++i4) {
                this.afterColQuery[i4].append(" WHERE " + String.valueOf(partColNames) + "=" + String.valueOf(partColValues));
                this.afterColVariables.get(i4).addAll(partColVariables);
            }
        }
        for (i = 0; i < this.afterColQuery.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.afterColQuery[i].append(" AND ");
                this.afterColQuery[i].append(CassandraUtil.quote(this.clusterColumns.get(j).getName()));
                this.afterColQuery[i].append(j < i ? "=?" : (this.clusteringOrder.get(j) == ClusteringOrder.ASC ? ">?" : "<?"));
                this.afterColVariables.get(i).add(this.clusterColumns.get(j).getName());
            }
        }
        if (filterColumn != null && !this.partitionKeyFilter) {
            this.initialQuery.append(" WHERE " + CassandraUtil.quote(filterColumn) + "=?");
            this.initialVariables.add(filterColumn);
            this.afterRowQuery.append(" AND " + CassandraUtil.quote(filterColumn) + "=?");
            this.afterRowVariables.add(filterColumn);
            if (!this.clusterKeyFilter) {
                for (i = 0; i < this.afterColQuery.length; ++i) {
                    this.afterColQuery[i].append(" AND " + CassandraUtil.quote(filterColumn) + "=?");
                    this.afterColVariables.get(i).add(filterColumn);
                }
            }
        }
        this.initialQuery.append(" LIMIT " + this.fetchSize);
        this.afterRowQuery.append(" LIMIT " + this.fetchSize);
        if (this.clusterKeyFilter) {
            this.initialQuery.append(" ALLOW FILTERING");
            this.afterRowQuery.append(" ALLOW FILTERING");
        }
        for (i = 0; i < this.afterColQuery.length; ++i) {
            this.afterColQuery[i].append(" LIMIT " + this.fetchSize + " ALLOW FILTERING");
        }
        this.initialPS = this.prepare(this.initialQuery);
        this.afterRowPS = this.prepare(this.afterRowQuery);
        this.afterColPS = new PreparedStatement[this.afterColQuery.length];
        for (i = 0; i < this.afterColQuery.length; ++i) {
            this.afterColPS[i] = this.prepare(this.afterColQuery[i]);
        }
        logger.debug((Object)"sending initial query");
        this.rs = dbConn.getSession().execute((Statement)this.bindValues(this.initialPS, this.initialVariables));
    }

    private boolean fetch() {
        if (this.nCols == 0) {
            if (this.nRows < (long)this.fetchSize) {
                return false;
            }
            this.nCols = this.clusterColumns.size() > (this.clusterKeyFilter ? 1 : 0) ? this.clusterColumns.size() : 0;
        } else if (this.nCols == 1) {
            if (this.nRows < (long)this.fetchSize) {
                if (this.partitionKeyFilter) {
                    return false;
                }
                this.nCols = 0;
            } else {
                this.nCols = this.clusterColumns.size();
            }
        } else {
            this.nCols = this.nRows < (long)this.fetchSize ? (this.nCols == 2 && this.clusterKeyFilter ? 0 : --this.nCols) : this.clusterColumns.size();
        }
        if (this.nCols == 0) {
            logger.debug((Object)"sending row query");
            this.rs = this.dbConn.getSession().execute((Statement)this.bindValues(this.afterRowPS, this.afterRowVariables));
        } else {
            logger.debug((Object)("sending column query, nCols=" + this.nCols));
            this.rs = this.dbConn.getSession().execute((Statement)this.bindValues(this.afterColPS[this.nCols - 1], this.afterColVariables.get(this.nCols - 1)));
        }
        this.nRows = 0L;
        return true;
    }

    public boolean hasNext() {
        if (this.maxRecords > 0L && this.totalRows >= this.maxRecords) {
            return false;
        }
        while (this.rs.isExhausted()) {
            if (this.fetch()) continue;
            return false;
        }
        return true;
    }

    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastRow = this.rs.one();
        ++this.nRows;
        ++this.totalRows;
        return this.lastRow;
    }
}

