/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.utils.DKULogger;
import java.io.Closeable;

public abstract class DKUTracedAction
implements Closeable {
    private DKULogger logger;
    private String msg;
    private DSSMetrics.TimeCtx tctx;
    private String msgPrefix;

    protected void init(DKULogger logger, String metricNamePrefix, String msgPrefix, Object ... objects) {
        this.logger = logger;
        this.msgPrefix = msgPrefix;
        Object metricName = metricNamePrefix;
        metricName = objects.length > 0 ? (String)metricName + "." + objects[0].toString() : (String)metricName + ".unknown";
        this.tctx = DSSMetrics.timeCtx((String)metricName);
        if (logger.isTraceEnabled()) {
            this.msg = "";
            for (Object obj : objects) {
                if (this.msg.length() > 0) {
                    this.msg = this.msg + " ";
                }
                this.msg = obj == null ? this.msg + "null" : this.msg + obj.toString();
            }
            try {
                throw new Exception();
            }
            catch (Exception e) {
                logger.trace(() -> msgPrefix + " Start: " + this.msg, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.logger.trace(() -> this.msgPrefix + " End: " + this.msg);
        this.tctx.close();
    }
}

