/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.processors.transform.StringTransformation;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class VariablesService {
    public static final String VARIABLES_JSON_FILENAME = "variables.json";
    public static final String LOCAL_VARIABLES_JSON_FILENAME = "localvariables.json";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.variables");

    public abstract VariablesContext getForProject(String var1);

    public abstract VariablesContext getForProjectAndUserLogin(String var1, AuthCtx var2);

    public abstract VariablesContext getForGlobal();

    public abstract VariablesContext getForGlobalAndUserLogin(AuthCtx var1);

    public abstract VariablesContext getForConnectionAndUser(DSSConnection var1, AuthCtx var2);

    public abstract VariablesContext getForConnectionAndProjectAndUser(DSSConnection var1, AuthCtx var2, String var3);

    protected static void addLevel(HierarchicalVariablesContext hvc, TransactionRef t, String path) throws IOException {
        if (t.exists(path)) {
            try {
                JsonObject obj = (JsonObject)t.readObjectUnsafe(path, JsonObject.class);
                if (obj != null) {
                    hvc.addLevel(obj);
                }
            }
            catch (Exception e) {
                throw new IOException("Unable read JSON file: " + path, e);
            }
        }
    }

    public abstract VariablesContext getForProjectAndUser(AuthCtx var1, String var2);

    @Nonnull
    public static ProjectVariables readLocalUnresolvedProjectVariables(String projectKey, Transaction t) throws IOException {
        ProjectVariables pv = new ProjectVariables();
        pv.standard = (JsonObject)t.readObjectDefault(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), JsonObject.class);
        pv.local = (JsonObject)t.readObjectDefault(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), JsonObject.class);
        return pv;
    }

    public static ProjectVariablesWithComments readLocalUnresolvedProjectVariablesWithComments(String projectKey, Transaction t) throws IOException {
        ProjectVariablesWithComments pv = new ProjectVariablesWithComments();
        pv.standard = VariablesService.readStringUTF8ForJson5Default(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), t);
        pv.local = VariablesService.readStringUTF8ForJson5Default(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), t);
        return pv;
    }

    public static String readStringUTF8ForJson5Default(RelFile relFile, Transaction t) throws IOException {
        return t.isFile(relFile) ? VariablesService.tryUnicodeDecodeStringForJson5(t.readStringUTF8(relFile)) : "{}";
    }

    private static String tryUnicodeDecodeStringForJson5(String stringToDecode) {
        try {
            return StringTransformation.UNICODE_DECODE_4_DIGITS_ONLY.transform(stringToDecode, null);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Failed to decode string: %s", stringToDecode), (Throwable)e);
            return stringToDecode;
        }
    }

    public static void writeLocalProjectVariables(String projectKey, RWTransaction t, ProjectVariables pv, boolean commit) throws IOException {
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), pv.standard == null ? "{}" : JSON.prettyUnescapeHtml((Object)pv.standard));
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), pv.local == null ? "{}" : JSON.prettyUnescapeHtml((Object)pv.local));
        if (commit) {
            t.commit("Saved project variables for project " + projectKey);
        }
    }

    public static void writeLocalProjectVariables(String projectKey, RWTransaction t, ProjectVariablesWithComments pv, boolean commit) throws IOException {
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), StringUtils.isBlank((CharSequence)pv.standard) ? "{}" : pv.standard.stripTrailing());
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), StringUtils.isBlank((CharSequence)pv.local) ? "{}" : pv.local.stripTrailing());
        if (commit) {
            t.commit("Saved project variables for project " + projectKey);
        }
    }

    public static class ProjectVariables {
        public JsonObject standard = new JsonObject();
        public JsonObject local = new JsonObject();
    }

    public static class ProjectVariablesWithComments {
        public String standard = "{}";
        public String local = "{}";
    }
}

