/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.client;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.http.post.DatabricksInvokeServingEndpointRequest;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatabricksLambdaAPIClient
implements BaseLambdaAPIClient {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.test.databricks");

    private DatabricksLambdaAPIClient() {
    }

    public static BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(AuthCtx authCtx, DatabricksAPIDeploymentInfra infra, String endpointName, Collection<ApiEndpointQuery> queries, boolean forTest) throws IOException, DKUSecurityException, SQLException {
        String connectionName = infra.authConnection;
        if (connectionName == null) {
            throw new IllegalConfigurationException(String.format("No connection defined in infrastructure '%s'", infra.id));
        }
        BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses = new BaseLambdaAPIClient.ApiEndpointResponses();
        for (ApiEndpointQuery tq : queries) {
            BaseLambdaAPIClient.ResponseOrError result = new BaseLambdaAPIClient.ResponseOrError();
            result.query = tq;
            String queryJSON = JSON.json((Object)tq.q);
            try {
                logger.debugV("Submit query with name '%s' and body '%s' to Databricks endpoint '%s'", new Object[]{tq.name, queryJSON, endpointName});
                DatabricksInvokeServingEndpointRequest queryRequest = (DatabricksInvokeServingEndpointRequest)JSON.parse((JsonElement)tq.q, DatabricksInvokeServingEndpointRequest.class);
                result.response = DatabricksUtils.queryEndpoint(authCtx, connectionName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout(), endpointName, queryRequest);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failure while trying to send query '%s' to Databricks endpoint '%s'", new Object[]{queryJSON, endpointName});
                result.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            }
            apiEndpointResponses.responses.add(result);
        }
        return apiEndpointResponses;
    }

    public static ApiEndpointQuery updateQueryExpectedFormat(ApiEndpointQuery query, LambdaEndpointConfig.EndpointType endpointType) {
        switch (endpointType) {
            case STD_PREDICTION: {
                JsonObject features = DatabricksLambdaAPIClient.extractFeatures(query.q);
                DatabricksInvokeServingEndpointRequest databricksRequest = DatabricksLambdaAPIClient.getDatabricksRequestFromFeatures(features);
                JsonObject updatedQuery = JSON.toJsonObject((Object)databricksRequest);
                return new ApiEndpointQuery(query.name, updatedQuery);
            }
        }
        logger.warnV("Unsupported endpoint type: %s", new Object[]{endpointType});
        return query;
    }

    private static JsonObject extractFeatures(JsonObject query) {
        String featuresPropertyName = "features";
        if (query.has("features") && query.get("features").isJsonObject()) {
            return query.get("features").getAsJsonObject();
        }
        return query;
    }

    private static DatabricksInvokeServingEndpointRequest getDatabricksRequestFromFeatures(JsonObject features) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList dataEntry = new ArrayList();
        features.entrySet().forEach(entry -> {
            columns.add((String)entry.getKey());
            dataEntry.add(entry.getValue());
        });
        DatabricksInvokeServingEndpointRequest.DataframeSplit dataframeSplit = new DatabricksInvokeServingEndpointRequest.DataframeSplit(List.of(Integer.valueOf(0)), columns, List.of(dataEntry));
        return new DatabricksInvokeServingEndpointRequest(dataframeSplit);
    }
}

