/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class StartsWith
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object s1 = args[0];
            Object s2 = args[1];
            if (s1 != null && s2 != null && s1 instanceof String && s2 instanceof String) {
                return ((String)s1).startsWith((String)s2);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 strings");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.StartsWith.DOCUMENTATION", "Returns whether <code>s</code> starts with <code>sub</code>.").withParams("string s, string sub").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"Hello world\"", "\"He\"").returns("true"));
    }
}

