/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.function.Function;

class Extractors {
    private static final DateFormat date = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    Extractors() {
    }

    public static Function<ByteBuffer, Boolean> NewBoolExtractor(int start) {
        return buffer -> {
            byte value = buffer.get(start);
            if (value == 2) {
                return null;
            }
            return buffer.get(start) == 1;
        };
    }

    public static Function<ByteBuffer, Byte> NewByteExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 1) == 1) {
                return null;
            }
            return buffer.get(start);
        };
    }

    public static Function<ByteBuffer, Long> NewInt16Extractor(int start) {
        return buffer -> {
            if (buffer.get(start + 2) == 1) {
                return null;
            }
            short value = buffer.getShort(start);
            return value;
        };
    }

    public static Function<ByteBuffer, Long> NewInt32Extractor(int start) {
        return buffer -> {
            if (buffer.get(start + 4) == 1) {
                return null;
            }
            int value = buffer.getInt(start);
            return value;
        };
    }

    public static Function<ByteBuffer, Long> NewInt64Extractor(int start) {
        return buffer -> {
            if (buffer.get(start + 8) == 1) {
                return null;
            }
            return buffer.getLong(start);
        };
    }

    public static Function<ByteBuffer, Double> NewFixedDecimalExtractor(int start, int fieldLength) {
        return buffer -> {
            if (buffer.get(start + fieldLength) == 1) {
                return null;
            }
            String str = Extractors.getString(buffer, start, fieldLength, 1);
            return Double.parseDouble(str);
        };
    }

    public static Function<ByteBuffer, Double> NewFloatExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 4) == 1) {
                return null;
            }
            return buffer.getFloat(start);
        };
    }

    public static Function<ByteBuffer, Double> NewDoubleExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 8) == 1) {
                return null;
            }
            return buffer.getDouble(start);
        };
    }

    public static Function<ByteBuffer, LocalDate> NewDateExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 10) == 1) {
                return null;
            }
            return Extractors.parseDate(buffer, start, 10, date);
        };
    }

    public static Function<ByteBuffer, String> NewDateAsStringExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 10) == 1) {
                return null;
            }
            return new String(buffer.array(), start, 10, StandardCharsets.ISO_8859_1);
        };
    }

    public static Function<ByteBuffer, LocalDateTime> NewDateTimeExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 19) == 1) {
                return null;
            }
            return Extractors.parseDateTime(buffer, start, 19, dateTime);
        };
    }

    public static Function<ByteBuffer, String> NewDateTimeAsStringExtractor(int start) {
        return buffer -> {
            if (buffer.get(start + 19) == 1) {
                return null;
            }
            return new String(buffer.array(), start, 19, StandardCharsets.ISO_8859_1);
        };
    }

    public static Function<ByteBuffer, String> NewStringExtractor(int start, int fieldLength) {
        return buffer -> {
            if (buffer.get(start + fieldLength) == 1) {
                return null;
            }
            return Extractors.getString(buffer, start, fieldLength, 1);
        };
    }

    public static Function<ByteBuffer, String> NewWStringExtractor(int start, int fieldLength) {
        return buffer -> {
            if (buffer.get(start + fieldLength * 2) == 1) {
                return null;
            }
            return Extractors.getString(buffer, start, fieldLength, 2);
        };
    }

    public static Function<ByteBuffer, String> NewV_StringExtractor(int start) {
        return buffer -> {
            byte[] bytes = Extractors.parseBlob(buffer, start);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.ISO_8859_1);
        };
    }

    public static Function<ByteBuffer, String> NewV_WStringExtractor(int start) {
        return buffer -> {
            byte[] bytes = Extractors.parseBlob(buffer, start);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_16LE);
        };
    }

    public static Function<ByteBuffer, byte[]> NewBlobExtractor(int start) {
        return buffer -> Extractors.parseBlob(buffer, start);
    }

    private static byte[] parseBlob(ByteBuffer buffer, int start) {
        int fixedPortion = buffer.getInt(start);
        if (fixedPortion == 0) {
            return new byte[0];
        }
        if (fixedPortion == 1) {
            return null;
        }
        if (Extractors.isTiny(fixedPortion)) {
            return Extractors.getTinyBlob(start, buffer);
        }
        int blockStart = start + (fixedPortion & Integer.MAX_VALUE);
        byte blockFirstByte = buffer.get(blockStart);
        if (Extractors.isSmallBlock(blockFirstByte)) {
            return Extractors.getSmallBlob(buffer, blockStart);
        }
        return Extractors.getNormalBlob(buffer, blockStart);
    }

    private static LocalDate parseDate(ByteBuffer buffer, int start, int length, DateFormat format) {
        String str = new String(buffer.array(), start, length, StandardCharsets.ISO_8859_1);
        try {
            return LocalDate.parse(str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    private static LocalDateTime parseDateTime(ByteBuffer buffer, int start, int length, DateFormat format) {
        Object str = new String(buffer.array(), start, length, StandardCharsets.ISO_8859_1);
        try {
            if (((String)str).length() >= 10 && ((String)str).charAt(10) == ' ') {
                str = ((String)str).substring(0, 10) + "T" + ((String)str).substring(11);
            }
            return LocalDateTime.parse((CharSequence)str);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    private static String getString(ByteBuffer buffer, int start, int fieldLength, int charSize) {
        int end = Extractors.getEndOfStringPos(buffer.array(), start, fieldLength, charSize);
        if (charSize == 1) {
            return new String(Arrays.copyOfRange(buffer.array(), start, end), StandardCharsets.ISO_8859_1);
        }
        return new String(Arrays.copyOfRange(buffer.array(), start, end), StandardCharsets.UTF_16LE);
    }

    private static int getEndOfStringPos(byte[] buffer, int start, int fieldLength, int charSize) {
        int fieldTo = start + fieldLength * charSize;
        int strLen = 0;
        for (int i = start; i < fieldTo && (buffer[i] != 0 || buffer[i + (charSize - 1)] != 0); i += charSize) {
            ++strLen;
        }
        return start + strLen * charSize;
    }

    private static boolean isTiny(int fixedPortion) {
        int bitCheck1 = fixedPortion & Integer.MIN_VALUE;
        int bitCheck2 = fixedPortion & 0x30000000;
        return bitCheck1 == 0 && bitCheck2 != 0;
    }

    private static boolean isSmallBlock(byte value) {
        return (value & 1) == 1;
    }

    private static byte[] getNormalBlob(ByteBuffer buffer, int blockStart) {
        int blobLen = buffer.getInt(blockStart) / 2;
        int blobStart = blockStart + 4;
        int blobEnd = blobStart + blobLen;
        return Arrays.copyOfRange(buffer.array(), blobStart, blobEnd);
    }

    private static byte[] getSmallBlob(ByteBuffer buffer, int blockStart) {
        byte blockFirstByte = buffer.get(blockStart);
        int blobLen = Extractors.unsign(blockFirstByte) >> 1;
        int blobStart = blockStart + 1;
        int blobEnd = blobStart + blobLen;
        return Arrays.copyOfRange(buffer.array(), blobStart, blobEnd);
    }

    private static byte[] getTinyBlob(int start, ByteBuffer buffer) {
        int intVal = buffer.getInt(start);
        int length = intVal >> 28;
        int end = start + length;
        return Arrays.copyOfRange(buffer.array(), start, end);
    }

    private static int unsign(byte value) {
        return value & 0xFF;
    }
}

