/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

class Lzf {
    byte[] inBuffer;
    byte[] outBuffer;
    int inIndex;
    int outIndex;
    int inLen;

    Lzf(byte[] inBuffer, byte[] outBuffer) {
        this.inBuffer = inBuffer;
        this.outBuffer = outBuffer;
    }

    public int decompress(int len) throws IllegalArgumentException {
        this.inLen = len;
        this.reset();
        if (this.inLen == 0) {
            return 0;
        }
        while (this.inIndex < this.inLen) {
            int ctrl = Lzf.unsign(this.inBuffer[this.inIndex]);
            ++this.inIndex;
            if (ctrl < 32) {
                this.copyByteSequence(ctrl);
                continue;
            }
            this.expandRepeatedBytes(ctrl);
        }
        return this.outIndex;
    }

    private void reset() {
        this.inIndex = 0;
        this.outIndex = 0;
    }

    private void copyByteSequence(int ctrl) throws IllegalArgumentException {
        int len = ctrl + 1;
        if (this.outIndex + len > this.outBuffer.length) {
            throw new IllegalArgumentException("output array is too small");
        }
        System.arraycopy(this.inBuffer, this.inIndex, this.outBuffer, this.outIndex, len);
        this.outIndex += len;
        this.inIndex += len;
    }

    private void expandRepeatedBytes(int ctrl) throws IllegalArgumentException {
        int length = ctrl >> 5;
        int reference = this.outIndex - ((ctrl & 0x1F) << 8) - 1;
        if (length == 7) {
            length += Lzf.unsign(this.inBuffer[this.inIndex]);
            ++this.inIndex;
        }
        if (this.outIndex + length + 2 > this.outBuffer.length) {
            throw new IllegalArgumentException("output array is too small");
        }
        reference -= Lzf.unsign(this.inBuffer[this.inIndex]);
        ++this.inIndex;
        length += 2;
        while (length > 0) {
            int size = Math.min(length, this.outIndex - reference);
            reference = this.copyFromReferenceAndIncrement(reference, size);
            length -= size;
        }
    }

    private int copyFromReferenceAndIncrement(int reference, int size) {
        System.arraycopy(this.outBuffer, reference, this.outBuffer, this.outIndex, size);
        this.outIndex += size;
        return reference + size;
    }

    private static int unsign(byte value) {
        return value & 0xFF;
    }
}

