/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.activity;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.activity.UsageSummaryModel;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.blueprints.HookPhase;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.blueprints.ui.view_components.ViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.containers.SequentialLayout;
import com.dataiku.gh.core.models.blueprints.ui.view_components.containers.ViewComponentContainer;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesDataService;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsDataService;
import com.dataiku.gh.core.services.monitoring.IMonitoringDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.storage.sql.search.PartialEnrichedArtifact;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.auth.GHCustomUserAuthenticatorDelegator;
import com.dataiku.gh.security.auth.GHCustomUserSupplierDelegator;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.gh.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;

public class GlobalUsageSummaryBuilder {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private GHCustomUserAuthenticatorDelegator dssCustomUserAuthenticatorDelegator;
    @Autowired
    private GHCustomUserSupplierDelegator dssCustomUserSupplierDelegate;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");
    private static final String pythonBaseEnvVersion = GlobalUsageSummaryBuilder.getPythonBaseEnvVersion();
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private ICustomPagesDataService customPagesDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IBlueprintVersionMigrationPathsDataService blueprintVersionMigrationPathsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IHistoryDataService historyDataService;
    @Autowired
    private IMonitoringDataService monitoringDataService;

    public GlobalUsageSummaryBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @GHReadonlyTransaction
    public UsageSummaryModel.MonitoringReport buildGlobalMonitoringReport() throws IOException {
        UsageSummaryModel.MonitoringReport ret = new UsageSummaryModel.MonitoringReport();
        try (ITransactionScope ts = this.transactionHandler.openNewReadTransaction();){
            this.buildMigrationPathsReport(ret.governMigrationPaths);
            this.buildCustomPagesReport(ret.governCustomPages);
            this.buildBlueprintsAndArtifactReports(ret.governBlueprints, ret.governAllArtifacts, ret.governDkuProjects, ret.governDkuDatasets, ret.governDkuBundles, ret.governDkuSavedModels, ret.governDkuSavedModelVersions, ret.governDkuRetrievableKnowledges, ret.governDkuAPIDeployerInfras, ret.governDkuAPIDeployerDeployments, ret.governDkuProjectDeployerInfras, ret.governDkuProjectDeployerDeployments, ret.governBusinessInitiatives, ret.governGovernProjects, ret.governGovernBundles, ret.governGovernModels, ret.governGovernModelVersions, ret.governCustomBlueprints);
            this.buildHistoryReport(ret.governHistory);
            this.buildDBTablesReport(ret.governDBTables);
            ts.commit();
        }
        return ret;
    }

    @GHReadonlyTransaction
    public UsageSummaryModel.SummaryReport buildGlobalSummary(boolean withPerProject) throws Exception {
        List<AbstractGlobalScopePublicAPIKey> globalScopePublicAPIKeys;
        Map<String, UserLastActivity> usersActivity;
        List<UsersDAO.User> users;
        UsageSummaryModel.SummaryReport ret = new UsageSummaryModel.SummaryReport();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        ret.nodeType = ApplicationConfigurator.getNodeType();
        ret.deploymentMode = DKUApp.getDeploymentMode();
        ret.cloudStacksCloud = DKUApp.getCloudStacksCloud();
        try (Transaction t = this.transactionService.beginRead();){
            ret.licenseLimits = this.licenseEnforcementService.getLimitsStatus();
            users = this.usersDAO.listUsersUnsafe();
            usersActivity = this.usersService.getAllUsersActivity(true);
            globalScopePublicAPIKeys = this.publicAPIKeysService.listGlobalAPIKeys();
        }
        for (UsersDAO.User u : users) {
            try {
                String loginHash = DigestUtils.md5Hex((String)u.login.toLowerCase(Locale.ENGLISH));
                ArrayList<Map<String, List<String>>> mapsWhereToAddTheUser = new ArrayList<Map<String, List<String>>>();
                if (!u.enabled) {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.disabledByLogin);
                } else {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.byLogin);
                }
                ret.userDetailedReport.inc(u.sourceType);
                for (Map map : mapsWhereToAddTheUser) {
                    ArrayList<String> profileList;
                    String resultingProfile = u.userProfile;
                    if (resultingProfile == null) {
                        resultingProfile = "unknown";
                    }
                    if ((profileList = (ArrayList<String>)map.get(resultingProfile)) == null) {
                        profileList = new ArrayList<String>();
                        map.put(resultingProfile, profileList);
                    }
                    profileList.add(loginHash);
                }
                UserLastActivity activity = usersActivity.get(u.login);
                if (activity == null) continue;
                ret.userActivity.put(loginHash, activity.lastSessionActivity);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to increment counters for user '" + u.login + "' in the global report computation : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        for (AbstractGlobalScopePublicAPIKey globalScopePublicAPIKey : globalScopePublicAPIKeys) {
            if (globalScopePublicAPIKey instanceof LegacyGlobalScopePublicAPIKey) {
                ++ret.apiKeys.globalScopeApiKeysWithoutGroupsCount;
                continue;
            }
            if (globalScopePublicAPIKey instanceof GlobalScopePublicAPIKeyWithGroups) {
                ++ret.apiKeys.globalScopeApiKeysWithGroupsCount;
                continue;
            }
            logger.warnV("Unknown type '%s' of global scope public API key for key with id '%s'", new Object[]{((Object)((Object)globalScopePublicAPIKey)).getClass(), globalScopePublicAPIKey.id});
        }
        try {
            ret.generalSettings.sso = gs.ssoSettings.enabled;
            if (ret.generalSettings.sso) {
                ret.generalSettings.ssoProtocol = gs.ssoSettings.protocol;
            }
            ret.generalSettings.ssoProvisioningEnabled = gs.ssoSettings.autoProvisionUsersAtLoginTime;
            ret.generalSettings.ldap = gs.ldapSettings.enabled;
            ret.generalSettings.ldapAuthEnabled = gs.ldapSettings.authenticationEnabled;
            ret.generalSettings.ldapProvisioningEnabled = gs.ldapSettings.autoImportUsers;
            ret.generalSettings.azureADSupplierEnabled = gs.azureADSettings.enabled;
            ret.generalSettings.azureADProvisioningEnabled = gs.azureADSettings.autoProvisionUsersAtLoginTime;
            ret.generalSettings.pamAuthenticatorEnabled = gs.pamSettings.enabled;
            ret.generalSettings.customAuthenticatorEnabled = this.dssCustomUserAuthenticatorDelegator.getAuthenticatorSettings().isAuthenticationEnabled();
            ret.generalSettings.customUserSupplierEnabled = this.dssCustomUserSupplierDelegate.getUserSupplierSettings().isEnabled();
            ret.generalSettings.enrichDSSUserFromLdapEnabled = false;
            ret.generalSettings.hashApiKeys = gs.security.hashApiKeys;
            ret.generalSettings.apiKeysLifetimeDays = gs.security.apiKeysLifetimeDays;
            ret.generalSettings.hasDSSURL = StringUtils.isNotBlank((String)gs.studioExternalUrl);
            ret.generalSettings.hasAdminContact = StringUtils.isNotBlank((String)gs.studioAdminContact);
            ret.generalSettings.graphite = StringUtils.isNotBlank((String)gs.graphiteServerUrl);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarise the general settings usage in the global report computation : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.summarizePythonCodeEnvs(ret.pythonCodeEnvs);
        try (ITransactionScope ts = this.transactionHandler.openNewReadTransaction();){
            ret.governPostgresVersion = this.monitoringDataService.getPostgresVersion();
            this.buildMigrationPathsReport(ret.governMigrationPaths);
            this.buildCustomPagesReport(ret.governCustomPages);
            this.buildBlueprintsAndArtifactReports(ret.governBlueprints, ret.governAllArtifacts, ret.governDkuProjects, ret.governDkuDatasets, ret.governDkuBundles, ret.governDkuSavedModels, ret.governDkuSavedModelVersions, ret.governDkuRetrievableKnowledges, ret.governDkuAPIDeployerInfras, ret.governDkuAPIDeployerDeployments, ret.governDkuProjectDeployerInfras, ret.governDkuProjectDeployerDeployments, ret.governBusinessInitiatives, ret.governGovernProjects, ret.governGovernBundles, ret.governGovernModels, ret.governGovernModelVersions, ret.governCustomBlueprints);
            this.buildHistoryReport(ret.governHistory);
            this.buildDBTablesReport(ret.governDBTables);
            ts.commit();
        }
        return ret;
    }

    public void summarizePythonCodeEnvs(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport) {
        codeEnvsSummaryReport.baseEnvVersion = pythonBaseEnvVersion;
    }

    private static String getPythonBaseEnvVersion() {
        String pythonBin = System.getenv("DKUPYTHONBIN");
        if (pythonBin == null) {
            logger.error((Object)"DKUPYTHONBIN env variable is not set!");
            return null;
        }
        ProcessBuilder builder = new ProcessBuilder(new File(pythonBin).getAbsolutePath(), "-c", "import sysconfig;print(sysconfig.get_python_version())");
        try {
            return new String(DKUtils.execAndGetOutput((ProcessBuilder)builder, (String)"Could not get python version."), StandardCharsets.UTF_8).trim();
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed to get Python base env version. Interrupted while retrieving version.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get Python base env version.", (Throwable)e);
        }
        return "unknown";
    }

    private void inc(Map<String, Integer> countMap, String key) {
        this.inc((Map)countMap, (Object)key, 1);
    }

    private void inc(Map<String, Integer> countMap, String key, int increment) {
        Integer prev = countMap.get(key);
        if (prev == null) {
            prev = 0;
        }
        countMap.put(key, prev + increment);
    }

    private <T> void inc(Map<T, Integer> countMap, T key) {
        this.inc(countMap, key, 1);
    }

    private <T> void inc(Map<T, Integer> countMap, T key, int increment) {
        Integer prev = countMap.get(key);
        if (prev == null) {
            prev = 0;
        }
        countMap.put(key, prev + increment);
    }

    private <T> void addValue(Map<T, UsageSummaryModel.SimpleStats> simpleStatsMap, T key, int value) {
        UsageSummaryModel.SimpleStats ss = simpleStatsMap.computeIfAbsent(key, k -> new UsageSummaryModel.SimpleStats());
        ss.addValue(value);
    }

    private UsageSummaryModel.SimpleStats addValue(@Nullable UsageSummaryModel.SimpleStats simpleStats, int value) {
        UsageSummaryModel.SimpleStats ss = simpleStats;
        if (ss == null) {
            ss = new UsageSummaryModel.SimpleStats();
        }
        ss.addValue(value);
        return ss;
    }

    private int countViewComponents(ViewComponent vc) {
        int count = 1;
        if (vc instanceof ViewComponentContainer && ((ViewComponentContainer)vc).layout instanceof SequentialLayout) {
            count += ((SequentialLayout)((ViewComponentContainer)vc).layout).viewComponents.stream().mapToInt(this::countViewComponents).sum();
        }
        return count;
    }

    private void buildMigrationPathsReport(UsageSummaryModel.MigrationPathsReport migrationPathsReport) throws IOException {
        this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPaths().forEach(mp -> {
            ++migrationPathsReport.nbMigrationPaths;
            this.inc(migrationPathsReport.migrationPathsByStatus, mp.status);
            this.inc(migrationPathsReport.migrationPathsbyFromToSources.computeIfAbsent(IdentifiersUtils.getSourceFromBlueprintId(mp.blueprintVersionIdFrom.blueprintId), s -> new HashMap()).computeIfAbsent(IdentifiersUtils.getSourceFromBlueprintVersionId(mp.blueprintVersionIdFrom.versionId), s -> new HashMap()).computeIfAbsent(IdentifiersUtils.getSourceFromBlueprintId(mp.blueprintVersionIdTo.blueprintId), s -> new HashMap()), IdentifiersUtils.getSourceFromBlueprintVersionId(mp.blueprintVersionIdTo.versionId));
        });
    }

    private void buildCustomPagesReport(UsageSummaryModel.CustomPagesReport customPagesReport) throws IOException {
        this.customPagesDataService.listCustomPages().forEach(cp -> {
            ++customPagesReport.nbPages;
            this.inc(customPagesReport.pagesBySource, IdentifiersUtils.getSourceFromCustomPageId(cp.id));
            if (cp.visible) {
                ++customPagesReport.nbVisiblePages;
            }
            this.inc((Map)customPagesReport.pagesByType, (Object)cp.getType());
        });
    }

    private void addSingleSourceBlueprintVersion(UsageSummaryModel.SingleSourceBlueprintVersionsStats stats, EnrichedBlueprintVersion ebv) {
        ++stats.nbBlueprintVersions;
        this.inc(stats.blueprintVersionsByStatus, ebv.blueprintVersionTrace.status);
        stats.nbWorkflowSteps = this.addValue(stats.nbWorkflowSteps, ebv.blueprintVersion.workflowDefinition.stepDefinitions.size());
        int nbConditionalWorkflowSteps = Math.toIntExact(ebv.blueprintVersion.workflowDefinition.stepDefinitions.stream().filter(stepDefinition -> stepDefinition.visibilityCondition != null).count());
        stats.nbConditionalWorkflowSteps = this.addValue(stats.nbConditionalWorkflowSteps, nbConditionalWorkflowSteps);
        List signoffConfigs = Optional.ofNullable(ebv.signoffsConfigurations).orElse(new ArrayList());
        stats.nbSignoffConfigs = this.addValue(stats.nbSignoffConfigs, signoffConfigs.size());
        for (SignoffConfiguration signoffConfiguration : signoffConfigs) {
            stats.feedbackGroupsBySignoffConfig = this.addValue(stats.feedbackGroupsBySignoffConfig, signoffConfiguration.feedbackUsersGroups.size());
        }
        stats.nbRecurrentSignoffConfigs = this.addValue(stats.nbRecurrentSignoffConfigs, signoffConfigs.stream().mapToInt(sc -> sc.recurrenceConfiguration.activated ? 1 : 0).sum());
        stats.nbFields = this.addValue(stats.nbFields, ebv.blueprintVersion.fieldDefinitions.size());
        Map<FieldType, Long> fieldTypeCounts = ebv.blueprintVersion.fieldDefinitions.values().stream().collect(Collectors.groupingBy(fd -> fd.fieldType, Collectors.counting()));
        fieldTypeCounts.forEach((fieldType, count) -> this.addValue(stats.fieldsByType, fieldType, count.intValue()));
        Map<SourceType, Long> fieldSourceCounts = ebv.blueprintVersion.fieldDefinitions.values().stream().filter(fd -> fd.fieldType == FieldType.REFERENCE).collect(Collectors.groupingBy(fd -> fd.sourceType, Collectors.counting()));
        fieldSourceCounts.forEach((sourceType, count) -> this.addValue(stats.referenceFieldsBySource, sourceType, count.intValue()));
        stats.nbHooks = this.addValue(stats.nbHooks, ebv.blueprintVersion.logicalHookList.size());
        Map<HookPhase, Long> hooksByPhases = ebv.blueprintVersion.logicalHookList.stream().flatMap(h -> h.phases.stream()).collect(Collectors.groupingBy(p -> p, Collectors.counting()));
        hooksByPhases.forEach((hookPhase, count) -> this.addValue(stats.hooksByPhase, hookPhase, count.intValue()));
        Collection<View> views = ebv.blueprintVersion.uiDefinition.views.values();
        stats.nbViews = this.addValue(stats.nbViews, views.size());
        for (View v : views) {
            int count2 = this.countViewComponents(v.viewComponent);
            stats.viewComponentsByView = this.addValue(stats.viewComponentsByView, count2);
        }
    }

    private void addArtifactStats(UsageSummaryModel.ArtifactsStats stats, PartialEnrichedArtifact a) {
        ++stats.nbArtifacts;
        if (a.artifact.status.archived) {
            ++stats.nbArchivedArtifacts;
        }
        int filledFields = a.artifact.fields.values().stream().filter(v -> v != null && (!(v instanceof List) || !CollectionUtils.isEmpty((Collection)((List)v)))).mapToInt(v -> 1).sum();
        stats.filledFieldsByArtifact = this.addValue(stats.filledFieldsByArtifact, filledFields);
        stats.referenceAttachmentsByArtifact = this.addValue(stats.referenceAttachmentsByArtifact, a.artifact.attachments.references.size());
        stats.uploadedFilesAttachmentsByArtifact = this.addValue(stats.uploadedFilesAttachmentsByArtifact, a.artifact.attachments.files.size());
        stats.signoffsByArtifact = this.addValue(stats.signoffsByArtifact, a.signoffs.size());
        a.signoffs.stream().collect(Collectors.groupingBy(signoff -> signoff.status, Collectors.counting())).forEach((status, count) -> this.addValue(stats.signoffsByArtifactByStatus, status, count.intValue()));
        a.signoffs.forEach(signoff -> {
            stats.feedbackCountByArtifactBySignoff = this.addValue(stats.feedbackCountByArtifactBySignoff, signoff.feedbackResponses.size());
            stats.cycleIndexByArtifactBySignoff = this.addValue(stats.cycleIndexByArtifactBySignoff, signoff.cycleIndex);
            int recurrence = signoff.configuration.recurrenceConfiguration.activated ? 1 : 0;
            stats.recurrentSignoffsByArtifactBySignoff = this.addValue(stats.recurrentSignoffsByArtifactBySignoff, recurrence);
        });
    }

    private void buildBlueprintsAndArtifactReports(UsageSummaryModel.BlueprintsReport blueprintsReport, UsageSummaryModel.AllArtifactsReport allArtifactsReport, UsageSummaryModel.DkuProjectsReport dkuProjectsReport, UsageSummaryModel.DkuDatasetsReport dkuDatasetsReport, UsageSummaryModel.DkuBundlesReport dkuBundlesReport, UsageSummaryModel.DkuSavedModelsReport dkuSavedModelsReport, UsageSummaryModel.DkuSavedModelVersionsReport dkuSavedModelVersionsReport, UsageSummaryModel.DkuRetrievableKnowledgesReport dkuRetrievableKnowledgesReport, UsageSummaryModel.DkuAPIDeployerInfrasReport dkuAPIDeployerInfrasReport, UsageSummaryModel.DkuAPIDeployerDeploymentsReport dkuAPIDeployerDeploymentsReport, UsageSummaryModel.DkuProjectDeployerInfrasReport dkuProjectDeployerInfrasReport, UsageSummaryModel.DkuProjectDeployerDeploymentsReport dkuProjectDeployerDeploymentsReport, UsageSummaryModel.BusinessInitiativesReport businessInitiativesReport, UsageSummaryModel.GovernProjectsReport governProjectsReport, UsageSummaryModel.GovernBundlesReport governBundlesReport, UsageSummaryModel.GovernModelsReport governModelsReport, UsageSummaryModel.GovernModelVersionsReport governModelVersionsReport, UsageSummaryModel.CustomBlueprintsReport customBlueprintsReport) throws IOException {
        Map<String, Pair> allBlueprints = this.blueprintsDataService.listBlueprintVersions().stream().collect(Collectors.toMap(ebv -> ebv.blueprint.id, ebv -> {
            ArrayList<EnrichedBlueprintVersion> ebvList = new ArrayList<EnrichedBlueprintVersion>();
            ebvList.add((EnrichedBlueprintVersion)ebv);
            return ImmutablePair.of((Object)ebv.blueprint, ebvList);
        }, (i1, i2) -> {
            ((List)i1.getRight()).addAll((Collection)i2.getRight());
            return i1;
        }));
        allBlueprints.forEach((blueprintId, blueprintData) -> {
            Blueprint bp = (Blueprint)blueprintData.getLeft();
            IdentifiersUtils.ItemSource bpSource = IdentifiersUtils.getSourceFromBlueprintId(bp.id);
            ++blueprintsReport.nbBlueprints;
            this.inc(blueprintsReport.blueprintsBySource, bpSource);
            if (bpSource == IdentifiersUtils.ItemSource.CUSTOM) {
                ++customBlueprintsReport.nbBlueprints;
            }
            HashMap blueprintVersionsByBlueprintBySource = new HashMap();
            HashMap blueprintVersionsByBlueprintByStatus = new HashMap();
            ((List)blueprintData.getRight()).forEach(ebpv -> {
                IdentifiersUtils.ItemSource bpvSource = IdentifiersUtils.getSourceFromBlueprintVersionId(ebpv.blueprintVersion.id.versionId);
                ++blueprintsReport.nbBlueprintVersions;
                this.inc(blueprintsReport.blueprintVersionsBySource.computeIfAbsent(bpSource, s -> new HashMap()), bpvSource);
                this.inc(blueprintVersionsByBlueprintBySource, bpvSource);
                this.inc(blueprintsReport.blueprintVersionsByStatus, ebpv.blueprintVersionTrace.status);
                this.inc(blueprintVersionsByBlueprintByStatus, ebpv.blueprintVersionTrace.status);
                if (SystemProvidedConstants.BUSINESS_INITIATIVE.matchBlueprint(bp.id)) {
                    if (Objects.equals(SystemProvidedConstants.BUSINESS_INITIATIVE.getSingleDefaultBlueprintVersionId(), ebpv.blueprintVersion.id)) {
                        businessInitiativesReport.standardBlueprintVersionStatus = ebpv.blueprintVersionTrace.status;
                    } else if (bpvSource == IdentifiersUtils.ItemSource.CUSTOM) {
                        this.addSingleSourceBlueprintVersion(businessInitiativesReport.customBlueprintVersions, (EnrichedBlueprintVersion)ebpv);
                    }
                } else if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(bp.id)) {
                    if (Objects.equals(SystemProvidedConstants.GOVERN_PROJECT.getSingleDefaultBlueprintVersionId(), ebpv.blueprintVersion.id)) {
                        governProjectsReport.standardBlueprintVersionStatus = ebpv.blueprintVersionTrace.status;
                    } else if (bpvSource == IdentifiersUtils.ItemSource.CUSTOM) {
                        this.addSingleSourceBlueprintVersion(governProjectsReport.customBlueprintVersions, (EnrichedBlueprintVersion)ebpv);
                    }
                } else if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(bp.id)) {
                    if (Objects.equals(SystemProvidedConstants.GOVERN_BUNDLE.getSingleDefaultBlueprintVersionId(), ebpv.blueprintVersion.id)) {
                        governBundlesReport.standardBlueprintVersionStatus = ebpv.blueprintVersionTrace.status;
                    } else if (bpvSource == IdentifiersUtils.ItemSource.CUSTOM) {
                        this.addSingleSourceBlueprintVersion(governBundlesReport.customBlueprintVersions, (EnrichedBlueprintVersion)ebpv);
                    }
                } else if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(bp.id)) {
                    if (Objects.equals(SystemProvidedConstants.GOVERN_MODEL.getSingleDefaultBlueprintVersionId(), ebpv.blueprintVersion.id)) {
                        governModelsReport.standardBlueprintVersionStatus = ebpv.blueprintVersionTrace.status;
                    } else if (bpvSource == IdentifiersUtils.ItemSource.CUSTOM) {
                        this.addSingleSourceBlueprintVersion(governModelsReport.customBlueprintVersions, (EnrichedBlueprintVersion)ebpv);
                    }
                } else if (SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(bp.id)) {
                    if (Objects.equals(SystemProvidedConstants.GOVERN_MODEL_VERSION.getSingleDefaultBlueprintVersionId(), ebpv.blueprintVersion.id)) {
                        governModelVersionsReport.standardBlueprintVersionStatus = ebpv.blueprintVersionTrace.status;
                    } else if (bpvSource == IdentifiersUtils.ItemSource.CUSTOM) {
                        this.addSingleSourceBlueprintVersion(governModelVersionsReport.customBlueprintVersions, (EnrichedBlueprintVersion)ebpv);
                    }
                }
                if (bpSource == IdentifiersUtils.ItemSource.CUSTOM) {
                    this.addSingleSourceBlueprintVersion(customBlueprintsReport.blueprintVersions, (EnrichedBlueprintVersion)ebpv);
                }
            });
            for (Map.Entry entry : blueprintVersionsByBlueprintBySource.entrySet()) {
                this.addValue(blueprintsReport.blueprintVersionsByBlueprintBySource.computeIfAbsent(bpSource, s -> new HashMap()), (IdentifiersUtils.ItemSource)((Object)((Object)entry.getKey())), (Integer)entry.getValue());
            }
            for (Map.Entry entry : blueprintVersionsByBlueprintByStatus.entrySet()) {
                this.addValue(blueprintsReport.blueprintVersionsByBlueprintByStatus, (BlueprintVersionStatus)((Object)((Object)entry.getKey())), (Integer)entry.getValue());
            }
        });
        try (Stream<PartialEnrichedArtifact> stream = this.artifactsDataService.listArtifactsStream();){
            HashSet nodeIds = new HashSet();
            HashMap governedBundlesByProject = new HashMap();
            HashMap governedModelsByProject = new HashMap();
            HashMap governedModelVersionsByModel = new HashMap();
            stream.forEach(a -> {
                IdentifiersUtils.ItemSource bpSource = IdentifiersUtils.getSourceFromBlueprintId(a.artifact.blueprintVersionId.blueprintId);
                IdentifiersUtils.ItemSource bpvSource = IdentifiersUtils.getSourceFromBlueprintVersionId(a.artifact.blueprintVersionId.versionId);
                this.addArtifactStats(allArtifactsReport, (PartialEnrichedArtifact)a);
                if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuProjectsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        Object nodeId = a.artifact.fields.get("node_id");
                        if (nodeId instanceof String && StringUtils.isNotBlank((String)((String)nodeId))) {
                            nodeIds.add((String)nodeId);
                        }
                        ++dkuProjectsReport.nbProjects;
                        if (this.isGoverned((PartialEnrichedArtifact)a)) {
                            ++dkuProjectsReport.nbGovernedProjects;
                        }
                        Object datasets = a.artifact.fields.get("dataiku_datasets");
                        dkuProjectsReport.datasetsByProject = this.addValue(dkuProjectsReport.datasetsByProject, ((List)Optional.ofNullable(datasets).filter(List.class::isInstance).map(d -> (List)d).orElse(new ArrayList())).size());
                        Object bundles = a.artifact.fields.get("dataiku_bundles");
                        dkuProjectsReport.bundlesByProject = this.addValue(dkuProjectsReport.bundlesByProject, ((List)Optional.ofNullable(bundles).filter(List.class::isInstance).map(b -> (List)b).orElse(new ArrayList())).size());
                        governedBundlesByProject.computeIfAbsent(a.artifact.id, aid -> 0);
                        Object models = a.artifact.fields.get("dataiku_saved_models");
                        dkuProjectsReport.modelsByProject = this.addValue(dkuProjectsReport.modelsByProject, ((List)Optional.ofNullable(models).filter(List.class::isInstance).map(m -> (List)m).orElse(new ArrayList())).size());
                        governedModelsByProject.computeIfAbsent(a.artifact.id, aid -> 0);
                        Object retrievableKnowledges = a.artifact.fields.get("dataiku_retrievable_knowledges");
                        dkuProjectsReport.retrievableKnowledgesByProject = this.addValue(dkuProjectsReport.retrievableKnowledgesByProject, ((List)Optional.ofNullable(retrievableKnowledges).filter(List.class::isInstance).map(b -> (List)b).orElse(new ArrayList())).size());
                    }
                } else if (SystemProvidedConstants.DATAIKU_DATASET.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuDatasetsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuDatasetsReport.nbDatasets;
                    }
                } else if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuBundlesReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuBundlesReport.nbBundles;
                        parentArtifactId = a.artifact.fields.get("dataiku_project");
                        if (parentArtifactId instanceof String && StringUtils.isNotBlank((String)((String)parentArtifactId)) && this.isGoverned((PartialEnrichedArtifact)a)) {
                            this.inc(governedBundlesByProject, (Object)((String)parentArtifactId));
                        }
                    }
                } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuSavedModelsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuSavedModelsReport.nbSavedModels;
                        parentArtifactId = a.artifact.fields.get("dataiku_project");
                        if (parentArtifactId instanceof String && StringUtils.isNotBlank((String)((String)parentArtifactId)) && this.isGoverned((PartialEnrichedArtifact)a)) {
                            this.inc(governedModelsByProject, (Object)((String)parentArtifactId));
                        }
                        Object versions = a.artifact.fields.get("dataiku_saved_model_versions");
                        dkuSavedModelsReport.modelVersionsByModel = this.addValue(dkuSavedModelsReport.modelVersionsByModel, ((List)Optional.ofNullable(versions).filter(List.class::isInstance).map(v -> (List)v).orElse(new ArrayList())).size());
                        governedModelVersionsByModel.computeIfAbsent(a.artifact.id, aid -> 0);
                    }
                } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuSavedModelVersionsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuSavedModelVersionsReport.nbSavedModelVersions;
                        this.inc((Map)dkuSavedModelVersionsReport.savedModelVersionsByBPV, (Object)a.artifact.blueprintVersionId.versionId);
                        parentArtifactId = a.artifact.fields.get("dataiku_saved_model");
                        if (parentArtifactId instanceof String && StringUtils.isNotBlank((String)((String)parentArtifactId)) && this.isGoverned((PartialEnrichedArtifact)a)) {
                            this.inc(governedModelVersionsByModel, (Object)((String)parentArtifactId));
                        }
                    }
                } else if (SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuRetrievableKnowledgesReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuRetrievableKnowledgesReport.nbRetrievableKnowledges;
                    }
                } else if (SystemProvidedConstants.API_DEPLOYER_INFRA.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuAPIDeployerInfrasReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuAPIDeployerInfrasReport.nbAPIDeployerInfras;
                        Object depl = a.artifact.fields.get("deployments");
                        dkuAPIDeployerInfrasReport.apiDeployerDeploymentsByInfra = this.addValue(dkuAPIDeployerInfrasReport.apiDeployerDeploymentsByInfra, ((List)Optional.ofNullable(depl).filter(List.class::isInstance).map(d -> (List)d).orElse(new ArrayList())).size());
                    }
                } else if (SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuAPIDeployerDeploymentsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuAPIDeployerDeploymentsReport.nbAPIDeployerDeployments;
                    }
                } else if (SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuProjectDeployerInfrasReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuProjectDeployerInfrasReport.nbProjectDeployerInfras;
                        Object deployments = a.artifact.fields.get("deployments");
                        dkuProjectDeployerInfrasReport.projectDeployerDeploymentsByInfra = this.addValue(dkuProjectDeployerInfrasReport.projectDeployerDeploymentsByInfra, ((List)Optional.ofNullable(deployments).filter(List.class::isInstance).map(d -> (List)d).orElse(new ArrayList())).size());
                    }
                } else if (SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(dkuProjectDeployerDeploymentsReport.artifacts, (PartialEnrichedArtifact)a);
                    if (this.isNonArchivedDkuItem((PartialEnrichedArtifact)a)) {
                        ++dkuProjectDeployerDeploymentsReport.nbProjectDeployerDeployments;
                    }
                }
                if (SystemProvidedConstants.BUSINESS_INITIATIVE.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(businessInitiativesReport.artifacts, (PartialEnrichedArtifact)a);
                    this.inc(businessInitiativesReport.nbArtifactsBySource, bpvSource);
                } else if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(a.artifact.blueprintVersionId.blueprintId)) {
                    this.addArtifactStats(governProjectsReport.artifacts, (PartialEnrichedArtifact)a);
                    this.inc(governProjectsReport.nbArtifactsBySource, bpvSource);
                    Object dkuProjects = a.artifact.fields.get("dataiku_item");
                    governProjectsReport.dkuProjectsByGovernProject = this.addValue(governProjectsReport.dkuProjectsByGovernProject, ((List)Optional.ofNullable(dkuProjects).filter(List.class::isInstance).map(d -> (List)d).orElse(new ArrayList())).size());
                    Object bundles = a.artifact.fields.get("govern_bundles");
                    governBundlesReport.governBundlesByProject = this.addValue(governBundlesReport.governBundlesByProject, ((List)Optional.ofNullable(bundles).filter(List.class::isInstance).map(b -> (List)b).orElse(new ArrayList())).size());
                    Object models = a.artifact.fields.get("govern_models");
                    governModelsReport.governModelsByProject = this.addValue(governModelsReport.governModelsByProject, ((List)Optional.ofNullable(models).filter(List.class::isInstance).map(m -> (List)m).orElse(new ArrayList())).size());
                } else if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(governBundlesReport.artifacts, (PartialEnrichedArtifact)a);
                    this.inc(governBundlesReport.nbArtifactsBySource, bpvSource);
                } else if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(governModelsReport.artifacts, (PartialEnrichedArtifact)a);
                    this.inc(governModelsReport.nbArtifactsBySource, bpvSource);
                    Object versions = a.artifact.fields.get("govern_model_versions");
                    governModelVersionsReport.governModelVersionsByModel = this.addValue(governModelVersionsReport.governModelVersionsByModel, ((List)Optional.ofNullable(versions).filter(List.class::isInstance).map(v -> (List)v).orElse(new ArrayList())).size());
                } else if (SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(a.artifact.blueprintVersionId)) {
                    this.addArtifactStats(governModelVersionsReport.artifacts, (PartialEnrichedArtifact)a);
                    this.inc(governModelVersionsReport.nbArtifactsBySource, bpvSource);
                }
                if (bpSource == IdentifiersUtils.ItemSource.CUSTOM) {
                    this.addArtifactStats(customBlueprintsReport.artifacts, (PartialEnrichedArtifact)a);
                }
            });
            dkuProjectsReport.nbDistinctNodeIds = nodeIds.size();
            for (Integer value : governedBundlesByProject.values()) {
                dkuProjectsReport.governedBundlesByProject = this.addValue(dkuProjectsReport.governedBundlesByProject, value);
            }
            for (Integer value : governedBundlesByProject.values()) {
                dkuProjectsReport.governedModelsByProject = this.addValue(dkuProjectsReport.governedModelsByProject, value);
            }
            for (Integer value : governedModelVersionsByModel.values()) {
                dkuSavedModelsReport.governedModelVersionsByModel = this.addValue(dkuSavedModelsReport.governedModelVersionsByModel, value);
            }
        }
    }

    private boolean isDkuItem(PartialEnrichedArtifact partialEnrichedArtifact) {
        return SystemProvidedConstants.DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(partialEnrichedArtifact.artifact.blueprintVersionId.blueprintId) || SystemProvidedConstants.DEPLOYER_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(partialEnrichedArtifact.artifact.blueprintVersionId.blueprintId);
    }

    private boolean isNonArchivedDkuItem(PartialEnrichedArtifact partialEnrichedArtifact) {
        return this.isDkuItem(partialEnrichedArtifact) && !partialEnrichedArtifact.artifact.status.archived;
    }

    private boolean isGoverned(PartialEnrichedArtifact partialEnrichedArtifact) {
        if (!this.isNonArchivedDkuItem(partialEnrichedArtifact)) {
            return false;
        }
        Object governedBy = partialEnrichedArtifact.artifact.fields.get("governed_by");
        return governedBy instanceof String && StringUtils.isNotBlank((String)((String)governedBy));
    }

    private void buildHistoryReport(UsageSummaryModel.HistoryReport historyReport) throws IOException {
        historyReport.actionsByType = this.historyDataService.getActionCounts();
    }

    private void buildDBTablesReport(UsageSummaryModel.DBTablesReport dbTablesReport) throws IOException {
        dbTablesReport.countByTable = this.monitoringDataService.getTableCounts();
    }
}

