/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIBlueprintVersionsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IBlueprintsService blueprintsService;

    @AuditInline
    @RequestMapping(value={"/publicapi/blueprint/{blueprintId}/versions"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            List<UIBlueprintVersion> uiBlueprintVersions = this.blueprintsService.listBlueprintVersionsByBlueprint(authCtx, blueprintId);
            this.auditTrailService.generic("blueprint-versions-list").with("blueprintId", blueprintId).emit();
            PublicAPIBlueprintVersionsController.writeJSON((HttpServletResponse)resp, uiBlueprintVersions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-versions-list", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-version-get", "blueprintId", "${blueprintId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/publicapi/blueprint/{blueprintId}/version/{versionId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UIBlueprintVersion uiBlueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, BlueprintVersionId.build(blueprintId, versionId));
        PublicAPIBlueprintVersionsController.writeJSON((HttpServletResponse)resp, (Object)uiBlueprintVersion);
    }
}

