/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV14000
extends Migration {
    private static final List<Pair<String, String>> BLUEPRINT_VERSIONS = Lists.newArrayList((Object[])new Pair[]{ImmutablePair.of((Object)"dataiku_project", (Object)"default"), ImmutablePair.of((Object)"dataiku_saved_model_version", (Object)"augmented"), ImmutablePair.of((Object)"dataiku_saved_model_version", (Object)"agent"), ImmutablePair.of((Object)"dataiku_saved_model_version", (Object)"fine_tuning"), ImmutablePair.of((Object)"govern_project", (Object)"default"), ImmutablePair.of((Object)"govern_model_version", (Object)"default")});
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        List<String> migratedCustomsGovernSmvBpvs = this.migrateGovernSavedModelVersionBPVs(jdbcTemplate);
        for (Pair<String, String> blueprintVersionInfo : BLUEPRINT_VERSIONS) {
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{(String)blueprintVersionInfo.getLeft(), "blueprint_version_" + (String)blueprintVersionInfo.getRight() + ".json"}), "bp.system." + (String)blueprintVersionInfo.getLeft(), "bv.system." + (String)blueprintVersionInfo.getRight(), actionId, migrationTS);
        }
        MigrationEntitiesUtilsBetweenV13300AndBeyond.fixArtifacts(dbMigrationDAO, "artifact_blueprint_id = 'bp.system.dataiku_saved_model_version' AND (     artifact_version_id = 'bv.system.agent'     OR     artifact_version_id = 'bv.system.fine_tuning' ) AND jsonb_path_exists(artifact_json, '$.fields.algorithm')", MigrationV14000::removeAlgorithm, actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.fixArtifacts(dbMigrationDAO, "artifact_blueprint_id = 'bp.system.dataiku_saved_model_version' AND artifact_version_id = 'bv.system.agent' AND jsonb_path_exists(artifact_json, '$.fields.llm_type') ", MigrationV14000::removeLLmType, actionId, migrationTS);
        this.migrateLLMAugmented(jdbcTemplate, migratedCustomsGovernSmvBpvs);
    }

    protected List<String> migrateGovernSavedModelVersionBPVs(JdbcTemplate jdbcTemplate) throws IOException {
        List<JsonObject> governSmvBpvs;
        try (Stream<JsonObject> stream = MigrationEntitiesUtilsBetweenV13300AndBeyond.streamObjects(jdbcTemplate, "blueprint_versions", "blueprint_version_json", "blueprint_version_blueprint_id='bp.system.govern_model_version'");){
            governSmvBpvs = stream.toList();
        }
        List<JsonObject> compatibleCustoms = governSmvBpvs.stream().filter(bpv -> {
            JsonArray allowedBlueprints = MigrationJsonUtils.getArraySubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "allowedBlueprints").orElse(new JsonArray());
            return !MigrationV14000.isSystemDefaultBPV(bpv) && Objects.equals("REFERENCE", MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "fieldType").orElse(null)) && Objects.equals("STORE", MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "sourceType").orElse(null)) && Objects.equals("false", MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "required").orElse(null)) && Objects.equals(null, MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "listConfig").orElse(null)) && allowedBlueprints.contains((JsonElement)new JsonPrimitive("bp.system.govern_model")) && allowedBlueprints.contains((JsonElement)new JsonPrimitive("bp.system.govern_project"));
        }).toList();
        ArrayList<String> migratedCompatibleCustoms = new ArrayList<String>();
        for (JsonObject bpv2 : compatibleCustoms) {
            JsonObject newBpv;
            String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv2, "id", "blueprintId").orElse(null);
            String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv2, "id", "versionId").orElse(null);
            if (blueprintId == null || versionId == null || Objects.equals(bpv2, newBpv = MigrationV14000.migrateGovernModelVersionBPVsReferenceToParentToRemoveGovernProject((JsonObject)JSON.deepCopy((Object)bpv2)))) continue;
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, newBpv, blueprintId, versionId, (long)this.actionId, this.getMigrationTimestamp());
            migratedCompatibleCustoms.add(versionId);
        }
        return migratedCompatibleCustoms;
    }

    public static JsonObject migrateGovernModelVersionBPVsReferenceToParentToRemoveGovernProject(JsonObject bpv) {
        Optional<JsonArray> allowedBPs;
        String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null);
        String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null);
        if (blueprintId == null || versionId == null || !StringUtils.equals((CharSequence)blueprintId, (CharSequence)"bp.system.govern_model_version")) {
            return bpv;
        }
        if (StringUtils.equals((CharSequence)MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "label").orElse(null), (CharSequence)"Governed parent item")) {
            bpv.getAsJsonObject("fieldDefinitions").getAsJsonObject("govern_model").addProperty("label", "Governed model");
        }
        if ((allowedBPs = MigrationJsonUtils.getArraySubpath((JsonElement)bpv, "fieldDefinitions", "govern_model", "allowedBlueprints")).isPresent() && allowedBPs.get().contains((JsonElement)new JsonPrimitive("bp.system.govern_project"))) {
            allowedBPs.get().remove((JsonElement)new JsonPrimitive("bp.system.govern_project"));
        }
        Optional<JsonObject> views = MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "uiDefinition", "views");
        views.ifPresent(MigrationV14000::browseGovernModelFieldVCsFromViews);
        return bpv;
    }

    private static void browseGovernModelFieldVCsFromViews(JsonObject views) {
        for (String key : views.keySet()) {
            MigrationJsonUtils.getObjectSubpath((JsonElement)views, key, "viewComponent").ifPresent(MigrationV14000::browseGovernModelFields);
        }
    }

    private static void browseGovernModelFields(JsonObject viewComponent) {
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse(null);
        String fieldId = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "fieldId").orElse(null);
        String label = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "label").orElse(null);
        if (StringUtils.equals((CharSequence)"govern_model", (CharSequence)fieldId) && (StringUtils.equals((CharSequence)"card-reference-field", (CharSequence)type) || StringUtils.equals((CharSequence)"table-reference-field", (CharSequence)type)) && StringUtils.equals((CharSequence)"Governed parent item", (CharSequence)label)) {
            viewComponent.addProperty("label", "Governed model");
        } else if (StringUtils.equals((CharSequence)"container", (CharSequence)type)) {
            MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").ifPresent(vcs -> vcs.forEach(vc -> {
                if (vc.isJsonObject()) {
                    MigrationV14000.browseGovernModelFields(vc.getAsJsonObject());
                }
            }));
        }
    }

    protected void migrateLLMAugmented(JdbcTemplate jdbcTemplate, List<String> migratedCustomsGovernSmvBpvs) throws IOException {
        try (Stream<JsonObject> dkuAugmentedLLMsStream = MigrationEntitiesUtilsBetweenV13300AndBeyond.streamObjects(jdbcTemplate, "artifacts", "artifact_json", "artifact_blueprint_id='bp.system.dataiku_saved_model_version' AND artifact_version_id='bv.system.augmented'");){
            dkuAugmentedLLMsStream.forEach(dkuAugmentedLLM -> {
                String newGovernModelArtifactId = this.migrateLLMAugmentedGovernanceLayer(jdbcTemplate, (JsonObject)dkuAugmentedLLM, migratedCustomsGovernSmvBpvs);
                this.migrateLLMAugmentedDataikuLayer(jdbcTemplate, (JsonObject)dkuAugmentedLLM, newGovernModelArtifactId);
            });
        }
        catch (UncheckedIOException ue) {
            throw ue.getCause();
        }
        JsonObject governModelVersionBRA = jdbcTemplate.queryForStream(String.format("SELECT %s FROM %s WHERE %s FOR UPDATE", "blueprint_role_assignments_json", "blueprint_role_assignments", "blueprint_role_assignments_blueprint_id = 'bp.system.govern_model_version'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_role_assignments_json"), JsonObject.class)).findAny().orElse(new JSON.JsonBuilder().kv("blueprintId", (Object)"bp.system.govern_model_version").get());
        JsonArray governModelVersionInheritBPIds = MigrationJsonUtils.getArraySubpath((JsonElement)governModelVersionBRA, "inheritBlueprintIds").orElse(new JsonArray());
        governModelVersionInheritBPIds.remove((JsonElement)new JsonPrimitive("bp.system.govern_project"));
        governModelVersionBRA.add("inheritBlueprintIds", (JsonElement)governModelVersionInheritBPIds);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, governModelVersionBRA, "bp.system.govern_model_version", (long)this.actionId, this.getMigrationTimestamp());
        JsonObject dkuModelVersionBRA = jdbcTemplate.queryForStream(String.format("SELECT %s FROM %s WHERE %s FOR UPDATE", "blueprint_role_assignments_json", "blueprint_role_assignments", "blueprint_role_assignments_blueprint_id = 'bp.system.dataiku_saved_model_version'"), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_role_assignments_json"), JsonObject.class)).findAny().orElse(new JSON.JsonBuilder().kv("blueprintId", (Object)"bp.system.dataiku_saved_model_version").get());
        JsonArray dkuModelVersionInheritBPIds = MigrationJsonUtils.getArraySubpath((JsonElement)dkuModelVersionBRA, "inheritBlueprintIds").orElse(new JsonArray());
        dkuModelVersionInheritBPIds.remove((JsonElement)new JsonPrimitive("bp.system.dataiku_project"));
        dkuModelVersionBRA.add("inheritBlueprintIds", (JsonElement)dkuModelVersionInheritBPIds);
        JsonArray dkuModelVersionInheritFieldIds = MigrationJsonUtils.getArraySubpath((JsonElement)dkuModelVersionBRA, "inheritArtifactFieldIds").orElse(new JsonArray());
        dkuModelVersionInheritFieldIds.remove((JsonElement)new JsonPrimitive("dataiku_project"));
        dkuModelVersionBRA.add("inheritArtifactFieldIds", (JsonElement)dkuModelVersionInheritFieldIds);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, dkuModelVersionBRA, "bp.system.dataiku_saved_model_version", (long)this.actionId, this.getMigrationTimestamp());
    }

    @Nullable
    protected String migrateLLMAugmentedGovernanceLayer(JdbcTemplate jdbcTemplate, JsonObject dataikuSMV, List<String> validCustomsGovernSmvBpvs) throws UncheckedIOException {
        try {
            JsonObject governProjectArtifact;
            String dataikuSMVArtifactId = MigrationJsonUtils.getStringSubpath((JsonElement)dataikuSMV, "id").orElse(null);
            if (dataikuSMVArtifactId == null) {
                return null;
            }
            List<JsonObject> references = MigrationEntitiesUtilsBetweenV13300AndBeyond.getArtifactReferencesForField(jdbcTemplate, dataikuSMVArtifactId, "governed_by");
            if (references.isEmpty() || references.get(0) == null) {
                return null;
            }
            String governSavedModelVersionArtifactId = MigrationJsonUtils.getStringSubpath((JsonElement)references.get(0), "artifactIdTo").orElse(null);
            if (governSavedModelVersionArtifactId == null) {
                return null;
            }
            JsonObject governSMV = MigrationEntitiesUtilsBetweenV13300AndBeyond.getArtifact(jdbcTemplate, governSavedModelVersionArtifactId);
            if (governSMV == null) {
                return null;
            }
            String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)governSMV, "blueprintVersionId", "blueprintId").orElse(null);
            String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)governSMV, "blueprintVersionId", "versionId").orElse(null);
            if (!StringUtils.equals((CharSequence)blueprintId, (CharSequence)"bp.system.govern_model_version") || !StringUtils.equals((CharSequence)versionId, (CharSequence)"bv.system.default") && !validCustomsGovernSmvBpvs.contains(versionId)) {
                return null;
            }
            governSMV.addProperty("name", MigrationJsonUtils.getStringSubpath((JsonElement)dataikuSMV, "name").map(oldName -> oldName.replace("-", "_")).orElse("v1"));
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertArtifact(jdbcTemplate, governSMV, this.actionId, this.getMigrationTimestamp());
            JsonObject governSavedModel = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewArtifact(jdbcTemplate, "bp.system.govern_model", "bv.system.default", MigrationJsonUtils.getStringSubpath((JsonElement)dataikuSMV, "name").map(oldName -> "Retrieval of knowledge bank: " + oldName.replace("-", "_")).orElse("Retrieval of knowledge bank"));
            String governSavedModelArtifactId = governSavedModel.get("id").getAsString();
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertArtifact(jdbcTemplate, governSavedModel, this.actionId, this.getMigrationTimestamp());
            List<JsonObject> governSMVParentReferences = MigrationEntitiesUtilsBetweenV13300AndBeyond.getArtifactReferencesForField(jdbcTemplate, governSavedModelVersionArtifactId, "govern_model");
            if (CollectionUtils.isEmpty(governSMVParentReferences) || governSMVParentReferences.size() != 1 || governSMVParentReferences.get(0) == null) {
                return governSavedModelArtifactId;
            }
            String governProjectArtifactId = MigrationJsonUtils.getStringSubpath((JsonElement)governSMVParentReferences.get(0), "artifactIdTo").orElse(null);
            if (governProjectArtifactId != null && (governProjectArtifact = MigrationEntitiesUtilsBetweenV13300AndBeyond.getArtifact(jdbcTemplate, governProjectArtifactId)) != null && StringUtils.equals((CharSequence)MigrationJsonUtils.getStringSubpath((JsonElement)governProjectArtifact, "blueprintVersionId", "blueprintId").orElse(null), (CharSequence)"bp.system.govern_project")) {
                JsonObject referenceModelToProject = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewPlainFieldReference(governSavedModelArtifactId, governProjectArtifactId, "govern_project");
                MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertPlainFieldReference(jdbcTemplate, referenceModelToProject, this.actionId, this.getMigrationTimestamp());
            }
            JsonObject referenceModelVersionToModel = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewPlainFieldReference(governSavedModelVersionArtifactId, governSavedModelArtifactId, "govern_model");
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertPlainFieldReference(jdbcTemplate, referenceModelVersionToModel, this.actionId, this.getMigrationTimestamp());
            return governSavedModelArtifactId;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void migrateLLMAugmentedDataikuLayer(JdbcTemplate jdbcTemplate, JsonObject oldDataikuSavedModelVersion, @Nullable String newGovernModelArtifactId) throws UncheckedIOException {
        try {
            String dataikuProjectArtifactId;
            List<JsonObject> references;
            String dataikuSavedModelVersionArtifactId = oldDataikuSavedModelVersion.get("id").getAsString();
            JsonObject newDataikuSavedModel = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewArtifact(jdbcTemplate, "bp.system.dataiku_saved_model", "bv.system.default", MigrationJsonUtils.getStringSubpath((JsonElement)oldDataikuSavedModelVersion, "name").map(oldName -> "Retrieval of knowledge bank: " + oldName.replace("-", "_")).orElse("Retrieval of knowledge bank"));
            String newDataikuSavedModelArtifactId = newDataikuSavedModel.get("id").getAsString();
            JsonObject newDataikuSavedModelVersion = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewArtifact(dataikuSavedModelVersionArtifactId, "bp.system.dataiku_saved_model_version", "bv.system.augmented", MigrationJsonUtils.getStringSubpath((JsonElement)oldDataikuSavedModelVersion, "name").map(oldName -> oldName.replace("-", "_")).orElse("v1"));
            this.mapOldSMVToNewSMAndSMV(oldDataikuSavedModelVersion, newDataikuSavedModelVersion, newDataikuSavedModel);
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertArtifact(jdbcTemplate, newDataikuSavedModel, this.actionId, this.getMigrationTimestamp());
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertArtifact(jdbcTemplate, newDataikuSavedModelVersion, this.actionId, this.getMigrationTimestamp());
            if (newGovernModelArtifactId != null) {
                JsonObject referenceDataikuModelToGovernModel = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewPlainFieldReference(newDataikuSavedModelArtifactId, newGovernModelArtifactId, "governed_by");
                MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertPlainFieldReference(jdbcTemplate, referenceDataikuModelToGovernModel, this.actionId, this.getMigrationTimestamp());
            }
            if ((CollectionUtils.isNotEmpty(references = MigrationEntitiesUtilsBetweenV13300AndBeyond.getArtifactReferencesForField(jdbcTemplate, dataikuSavedModelVersionArtifactId, "dataiku_project")) || references.size() == 1) && (dataikuProjectArtifactId = (String)MigrationJsonUtils.getStringSubpath((JsonElement)references.get(0), "artifactIdTo").orElse(null)) != null) {
                JsonObject referenceDataikuModelToDataikuProject = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewPlainFieldReference(newDataikuSavedModelArtifactId, dataikuProjectArtifactId, "dataiku_project");
                MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertPlainFieldReference(jdbcTemplate, referenceDataikuModelToDataikuProject, this.actionId, this.getMigrationTimestamp());
            }
            MigrationEntitiesUtilsBetweenV13300AndBeyond.deletePlainFieldReference(jdbcTemplate, this.actionId, dataikuSavedModelVersionArtifactId, "dataiku_project", this.getMigrationTimestamp());
            JsonObject referenceDataikuModelVersionToDataikuModel = MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewPlainFieldReference(dataikuSavedModelVersionArtifactId, newDataikuSavedModelArtifactId, "dataiku_saved_model");
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertPlainFieldReference(jdbcTemplate, referenceDataikuModelVersionToDataikuModel, this.actionId, this.getMigrationTimestamp());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void mapOldSMVToNewSMAndSMV(JsonObject oldDataikuSavedModelVersion, JsonObject newDataikuSavedModelVersion, JsonObject newDataikuSavedModel) {
        JsonObject oldDataikuSavedModelVersionFields = MigrationJsonUtils.getObjectSubpath((JsonElement)oldDataikuSavedModelVersion, "fields").orElse(new JsonObject());
        JsonObject newDataikuSavedModelVersionFields = newDataikuSavedModelVersion.getAsJsonObject("fields");
        JsonObject newDataikuSavedModelFields = newDataikuSavedModel.getAsJsonObject("fields");
        String projectKey = MigrationJsonUtils.getStringSubpath((JsonElement)oldDataikuSavedModelVersionFields, "project_key").orElse("");
        String ragModelId = MigrationJsonUtils.getStringSubpath((JsonElement)oldDataikuSavedModelVersionFields, "rag_model_id").orElse("");
        String savedModelId = MigrationV14000.crc32HashShort(MigrationJsonUtils.getStringSubpath((JsonElement)oldDataikuSavedModelVersionFields, "retrievable_knowledge_id").orElse("") + ":" + ragModelId);
        String fullModelVersionId = String.format("S-%s-%s-%s", projectKey, savedModelId, ragModelId.replace("-", "_"));
        newDataikuSavedModelFields.add("tags", (JsonElement)new JsonArray());
        newDataikuSavedModelFields.add("node_id", oldDataikuSavedModelVersionFields.get("node_id"));
        newDataikuSavedModelFields.addProperty("createdBy", "admin");
        newDataikuSavedModelFields.addProperty("createdOn", (Number)this.getMigrationTimestamp());
        newDataikuSavedModelFields.add("description", null);
        newDataikuSavedModelFields.add("short_description", null);
        newDataikuSavedModelFields.add("project_key", oldDataikuSavedModelVersionFields.get("project_key"));
        newDataikuSavedModelFields.addProperty("activeVersion", fullModelVersionId);
        newDataikuSavedModelFields.addProperty("creation_date", String.valueOf(this.getMigrationTimestamp()));
        newDataikuSavedModelFields.addProperty("lastModifiedBy", "admin");
        newDataikuSavedModelFields.addProperty("lastModifiedOn", (Number)this.getMigrationTimestamp());
        newDataikuSavedModelFields.addProperty("saved_model_id", savedModelId);
        newDataikuSavedModelFields.add("automation_node", oldDataikuSavedModelVersionFields.get("automation_node"));
        newDataikuSavedModelFields.add("hidden_in_governable_items_table", oldDataikuSavedModelVersionFields.get("hidden_in_governable_items_table"));
        newDataikuSavedModelFields.addProperty("model_type", "LLM_GENERIC_RAW");
        newDataikuSavedModelFields.addProperty("saved_model_type", "RETRIEVAL_AUGMENTED_LLM");
        newDataikuSavedModelFields.addProperty("saved_model_handling_type", "RETRIEVAL_AUGMENTED_LLM");
        newDataikuSavedModelFields.add("custom_fields", null);
        newDataikuSavedModelVersionFields.addProperty("active", Boolean.valueOf(true));
        newDataikuSavedModelVersionFields.add("node_id", oldDataikuSavedModelVersionFields.get("node_id"));
        newDataikuSavedModelVersionFields.add("project_key", oldDataikuSavedModelVersionFields.get("project_key"));
        newDataikuSavedModelVersionFields.addProperty("creation_date", String.valueOf(this.getMigrationTimestamp()));
        newDataikuSavedModelVersionFields.addProperty("saved_model_id", savedModelId);
        newDataikuSavedModelVersionFields.add("automation_node", oldDataikuSavedModelVersionFields.get("automation_node"));
        newDataikuSavedModelVersionFields.addProperty("full_model_version_id", fullModelVersionId);
        newDataikuSavedModelVersionFields.add("hidden_in_governable_items_table", oldDataikuSavedModelVersionFields.get("hidden_in_governable_items_table"));
        newDataikuSavedModelVersionFields.addProperty("model_type", "LLM_GENERIC_RAW");
        newDataikuSavedModelVersionFields.addProperty("saved_model_type", "RETRIEVAL_AUGMENTED_LLM");
        newDataikuSavedModelVersionFields.addProperty("saved_model_handling_type", "RETRIEVAL_AUGMENTED_LLM");
    }

    private static JsonObject removeAlgorithm(JsonObject input) {
        Optional<JsonObject> fields = MigrationJsonUtils.getObjectSubpath((JsonElement)input, "fields");
        fields.ifPresent(fieldsJsonObject -> fieldsJsonObject.remove("algorithm"));
        return input;
    }

    private static JsonObject removeLLmType(JsonObject input) {
        Optional<JsonObject> fields = MigrationJsonUtils.getObjectSubpath((JsonElement)input, "fields");
        fields.ifPresent(fieldsJsonObject -> fieldsJsonObject.remove("llm_type"));
        return input;
    }

    private static boolean isSystemDefaultBPV(JsonObject bpv) {
        return StringUtils.equals((CharSequence)MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null), (CharSequence)"bv.system.default");
    }

    private static String crc32HashShort(String input) {
        CRC32 crc = new CRC32();
        crc.update(input.getBytes(StandardCharsets.UTF_8));
        return String.format("%08x", crc.getValue()).substring(0, 8);
    }
}

