/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactPostFilter;
import com.dataiku.gh.core.models.search.FieldPermissionArtifactPostFilter;
import com.dataiku.gh.core.services.artifacts.IArtifactPostFilterService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactPostFilterService
implements IArtifactPostFilterService {
    @Autowired
    private ICheckPermissionsService checkPermissionsService;

    @Override
    public boolean filter(EnrichedArtifact enrichedArtifact, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, ArtifactPostFilter artifactPostFilter) {
        ArtifactPostFilterVisitor artifactPostFilterVisitor = new ArtifactPostFilterVisitor(enrichedArtifact, assignedRolesAndPermissionsCtx);
        artifactPostFilter.accept(artifactPostFilterVisitor);
        return artifactPostFilterVisitor.artifactIsAccepted;
    }

    class ArtifactPostFilterVisitor
    implements ArtifactPostFilter.IArtifactPostFilterVisitor {
        private final EnrichedArtifact enrichedArtifact;
        private final AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;
        public boolean artifactIsAccepted = false;

        ArtifactPostFilterVisitor(EnrichedArtifact enrichedArtifact, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx) {
            this.enrichedArtifact = enrichedArtifact;
            this.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        }

        @Override
        public void visit(ArtifactPostFilter.FieldsPermissionsArtifactPostFilter fieldsPermissionsArtifactPostFilter) {
            if (MapUtils.isEmpty(fieldsPermissionsArtifactPostFilter.fieldPermissionArtifactPostFilters)) {
                this.artifactIsAccepted = true;
                return;
            }
            if (!fieldsPermissionsArtifactPostFilter.fieldPermissionArtifactPostFilters.containsKey(this.enrichedArtifact.blueprint.id)) {
                this.artifactIsAccepted = true;
                return;
            }
            this.artifactIsAccepted = fieldsPermissionsArtifactPostFilter.fieldPermissionArtifactPostFilters.get(this.enrichedArtifact.blueprint.id).stream().anyMatch(fieldPermissionArtifactPostFilter -> {
                if (fieldPermissionArtifactPostFilter.permission == FieldPermissionArtifactPostFilter.PermissionType.READ) {
                    return ArtifactPostFilterService.this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldPermissionArtifactPostFilter.fieldId);
                }
                return ArtifactPostFilterService.this.checkPermissionsService.hasFieldWritePermissionForWrite_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldPermissionArtifactPostFilter.fieldId);
            });
        }

        @Override
        public void visit(ArtifactPostFilter.BackreferenceFillerArtifactPostFilter backreferenceFillerArtifactPostFilter) {
            if (!ArtifactPostFilterService.this.checkPermissionsService.hasArtifactWritePermission_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem)) {
                return;
            }
            HashMap allowedFieldIdsByBlueprint = new HashMap();
            backreferenceFillerArtifactPostFilter.backreferenceFieldDefinition.references.forEach(fieldReference -> {
                if (!allowedFieldIdsByBlueprint.containsKey(fieldReference.blueprintId)) {
                    allowedFieldIdsByBlueprint.put(fieldReference.blueprintId, new HashSet());
                }
                ((Set)allowedFieldIdsByBlueprint.get(fieldReference.blueprintId)).add(fieldReference.fieldId);
            });
            if (allowedFieldIdsByBlueprint.containsKey(this.enrichedArtifact.blueprint.id)) {
                for (String fieldId : (Set)allowedFieldIdsByBlueprint.get(this.enrichedArtifact.blueprint.id)) {
                    FieldDefinition fieldDefinition = this.enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
                    if (fieldDefinition == null || fieldDefinition.fieldType != FieldType.REFERENCE || fieldDefinition.sourceType != SourceType.STORE || !ArtifactPostFilterService.this.checkPermissionsService.hasFieldWritePermissionForWrite_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldId)) continue;
                    StoredReferenceFieldDefinition storedReferenceFieldDefinition = (StoredReferenceFieldDefinition)fieldDefinition;
                    if (!storedReferenceFieldDefinition.allowedBlueprints.isEmpty() && !storedReferenceFieldDefinition.allowedBlueprints.contains(backreferenceFillerArtifactPostFilter.blueprintVersionId.blueprintId)) continue;
                    this.artifactIsAccepted = true;
                    break;
                }
            }
        }
    }
}

