/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts.migrator;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactFixStrategy;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactMigrator;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class ArtifactMigrator
implements IArtifactMigrator {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactFixStrategy artifactFixStrategy;

    @Override
    @GHMandatoryTransaction
    public void migrateImpactedArtifacts(BlueprintVersionId blueprintVersionId) throws IOException {
        try (Stream<EnrichedArtifact> searchResult = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Collections.singletonList(ArtifactFilter.BlueprintVersionsArtifactFilter.build(blueprintVersionId)), null, null);){
            searchResult.forEach(enrichedArtifact -> {
                boolean hasChanged = this.artifactFixStrategy.fixArtifact((EnrichedArtifact)enrichedArtifact);
                if (hasChanged) {
                    try {
                        this.artifactsDataService.storeArtifact((EnrichedArtifact)enrichedArtifact, false);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }
}

