/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.utils;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BlueprintVersionsDependencyGraph {
    private final Map<String, BlueprintVersionNode> blueprintVersionNodesMap = new HashMap<String, BlueprintVersionNode>();

    public static BlueprintVersionsDependencyGraph build(List<BlueprintVersionExport> blueprintVersionsWithOriginVersionId) {
        BlueprintVersionsDependencyGraph graph = new BlueprintVersionsDependencyGraph();
        for (BlueprintVersionExport blueprintVersionWithOriginVersionId : blueprintVersionsWithOriginVersionId) {
            graph.createNode(blueprintVersionWithOriginVersionId);
        }
        for (BlueprintVersionExport blueprintVersionWithOriginVersionId : blueprintVersionsWithOriginVersionId) {
            graph.addEdge(blueprintVersionWithOriginVersionId);
        }
        return graph;
    }

    public BlueprintVersionNode getNode(String versionId) {
        return this.blueprintVersionNodesMap.get(versionId);
    }

    private void createNode(BlueprintVersionExport blueprintVersionWithOriginVersionId) {
        if (blueprintVersionWithOriginVersionId == null) {
            throw new ValidationException("Syntax error in blueprintVersionsWithOriginVersion");
        }
        if (blueprintVersionWithOriginVersionId.blueprintVersion == null) {
            throw new ValidationException("blueprintVersion required");
        }
        if (blueprintVersionWithOriginVersionId.blueprintVersion.id == null) {
            throw new ValidationException("blueprintVersion.id required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId)) {
            throw new ValidationException("blueprintVersion.id.versionId required");
        }
        if (!this.blueprintVersionNodesMap.containsKey(blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId)) {
            BlueprintVersionNode node = new BlueprintVersionNode(blueprintVersionWithOriginVersionId);
            this.blueprintVersionNodesMap.put(blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId, node);
        }
    }

    private void addEdge(BlueprintVersionExport blueprintVersionWithOriginVersionId) {
        if (blueprintVersionWithOriginVersionId == null) {
            throw new ValidationException("Syntax error in blueprintVersionsWithOriginVersion");
        }
        if (blueprintVersionWithOriginVersionId.originVersionId == null) {
            return;
        }
        if (blueprintVersionWithOriginVersionId.blueprintVersion == null) {
            throw new ValidationException("blueprintVersion required");
        }
        if (blueprintVersionWithOriginVersionId.blueprintVersion.id == null) {
            throw new ValidationException("blueprintVersion.id required");
        }
        if (StringUtils.isBlank((CharSequence)blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId)) {
            throw new ValidationException("blueprintVersion.id.versionId required");
        }
        if (this.getNode(blueprintVersionWithOriginVersionId.originVersionId) == null) {
            throw new ValidationException("Blueprint version " + blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId + " references an unknown blueprint version: " + blueprintVersionWithOriginVersionId.originVersionId);
        }
        BlueprintVersionNode originNode = this.getNode(blueprintVersionWithOriginVersionId.originVersionId);
        BlueprintVersionNode node = this.getNode(blueprintVersionWithOriginVersionId.blueprintVersion.id.versionId);
        originNode.addDependantNode(node);
    }

    public Map<String, BlueprintVersionNode> getBlueprintVersionNodesMap() {
        return this.blueprintVersionNodesMap;
    }

    public static class BlueprintVersionNode {
        private final BlueprintVersionExport blueprintVersionWithOriginVersionId;
        private int dependencies = 0;
        private final Map<BlueprintVersionExport, BlueprintVersionNode> dependantNodes = new HashMap<BlueprintVersionExport, BlueprintVersionNode>();

        private BlueprintVersionNode(BlueprintVersionExport blueprintVersionWithOriginVersionId) {
            this.blueprintVersionWithOriginVersionId = blueprintVersionWithOriginVersionId;
        }

        private void addDependantNode(BlueprintVersionNode node) {
            if (!this.dependantNodes.containsKey(node.getBlueprintVersionWithOriginVersion())) {
                this.dependantNodes.put(node.getBlueprintVersionWithOriginVersion(), node);
                node.incrementDependencies();
            }
        }

        private void incrementDependencies() {
            ++this.dependencies;
        }

        public void decrementDependencies() {
            --this.dependencies;
        }

        public int getDependencies() {
            return this.dependencies;
        }

        public BlueprintVersionExport getBlueprintVersionWithOriginVersion() {
            return this.blueprintVersionWithOriginVersionId;
        }

        public Collection<BlueprintVersionNode> getDependantNodes() {
            return this.dependantNodes.values();
        }
    }
}

