/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.recipe;

import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.spark.GlobalMetastoreHiveConfig$;
import com.dataiku.dip.spark.LocalMetastoreHiveConfig$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.spark.recipe.DataikuSparkRecipeContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.spark.DataikuSparkContext;
import com.dataiku.dss.spark.DataikuSparkContext$;
import com.dataiku.dss.spark.FlowComputableType$;
import com.dataiku.dss.spark.FlowInput;
import com.dataiku.dss.spark.FlowOutput;
import com.dataiku.dss.spark.MultiTransformer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.internal.util.AbstractFileClassLoader;
import scala.reflect.internal.util.BatchSourceFile;
import scala.reflect.io.AbstractFile$;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Global;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.reporters.StoreReporter;

public final class SparkScalaRecipeExecutor$ {
    public static SparkScalaRecipeExecutor$ MODULE$;
    private final String defaultClassName;
    private final Logger logger;

    static {
        new SparkScalaRecipeExecutor$();
    }

    public String defaultClassName() {
        return this.defaultClassName;
    }

    public Logger logger() {
        return this.logger;
    }

    public void addJar(File jarFile, SparkContext sc) {
        sc.addJar(jarFile.getAbsolutePath().replace("%", "%25").replace("|", "%7C"));
    }

    public Class<?> compile(File compileDir, File jarFile, String source, CodeMode codeMode) {
        String string;
        CodeMode codeMode2 = codeMode;
        if (CodeMode.FREE_FORM.equals(codeMode2)) {
            string = new StringBuilder(80).append("class ").append(this.defaultClassName()).append(" extends (() => Any) with java.io.Serializable {\n").append("  def apply() = {\n").append(source).append("\n").append("  }\n").append("}\n").toString();
        } else if (CodeMode.FUNCTION.equals(codeMode2)) {
            string = new StringBuilder(333).append("class ").append(this.defaultClassName()).append(" extends com.dataiku.dss.spark.MultiTransformer {\n").append("  def transform(inputDatasets: Map[String, org.apache.spark.sql.DataFrame], ").append("sparkContext: org.apache.spark.SparkContext, ").append("sqlContext: org.apache.spark.sql.SQLContext, ").append("dkuContext: com.dataiku.dss.spark.DataikuSparkContext): ").append("Map[String, org.apache.spark.sql.DataFrame] = {\n").append(source).append("\n").append("  }\n").append("}\n").toString();
        } else {
            throw new MatchError((Object)codeMode2);
        }
        String wrappedCode = string;
        File codeFile = new File(compileDir, new StringBuilder(6).append(this.defaultClassName()).append(".scala").toString());
        FileUtils.writeStringToFile((File)codeFile, (String)wrappedCode);
        this.logger().info((Object)new StringBuilder(13).append("Compile into ").append(compileDir.getAbsolutePath()).toString());
        StoreReporter r = new StoreReporter();
        Global.Run compiler = com.dataiku.dip.sek.package$.MODULE$.makeCompiler((Reporter)r, compileDir);
        BatchSourceFile batchSourceFile = new BatchSourceFile(AbstractFile$.MODULE$.getFile(Path$.MODULE$.jfile2path(codeFile)));
        compiler.compileSources(Nil$.MODULE$.$colon$colon((Object)batchSourceFile));
        r.infos().foreach((Function1 & Serializable & scala.Serializable)info -> {
            SparkScalaRecipeExecutor$.$anonfun$compile$1(info);
            return BoxedUnit.UNIT;
        });
        File[] classFiles = compileDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        AbstractFileClassLoader classLoader = new AbstractFileClassLoader(AbstractFile$.MODULE$.getDirectory(Path$.MODULE$.jfile2path(compileDir)), this.getClass().getClassLoader());
        Class mainClass = classLoader.loadClass(this.defaultClassName());
        com.dataiku.dip.utils.package$.MODULE$.tryWith(new JarOutputStream(new FileOutputStream(jarFile)), (Function1 & Serializable & scala.Serializable)jar -> {
            SparkScalaRecipeExecutor$.$anonfun$compile$2(classFiles, jar);
            return BoxedUnit.UNIT;
        });
        return mainClass;
    }

    public void executeFunction(DataikuSparkRecipeContext dsc, Class<?> mainClass, File runDir, Option<String> hiveDB) {
        Tuple3<SparkContext, SQLContext, Object> tuple3;
        this.logger().info((Object)"Initializing spark context");
        SparkConf sparkConf = DataikuSparkContext$.MODULE$.buildSparkConf();
        Option<String> option = hiveDB;
        if (option instanceof Some) {
            tuple3 = package$.MODULE$.setupSQLContext(GlobalMetastoreHiveConfig$.MODULE$.apply("SparkScalaRecipeJob"), hiveDB, sparkConf);
        } else if (None$.MODULE$.equals(option)) {
            tuple3 = package$.MODULE$.setupSQLContext(LocalMetastoreHiveConfig$.MODULE$.apply(runDir, "SparkScalaRecipeJob"), (Option<String>)None$.MODULE$, sparkConf);
        } else {
            throw new MatchError(option);
        }
        Tuple3<SparkContext, SQLContext, Object> tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError(tuple32);
        }
        SparkContext sparkContext = (SparkContext)tuple32._1();
        SQLContext sqlContext = (SQLContext)tuple32._2();
        Tuple2 tuple2 = new Tuple2((Object)sparkContext, (Object)sqlContext);
        SparkContext sparkContext2 = (SparkContext)tuple2._1();
        SQLContext sqlContext2 = (SQLContext)tuple2._2();
        DataikuSparkContext$.MODULE$.getContext(sparkContext2);
        this.logger().info((Object)"Opening input datasets");
        Map inputs = ((TraversableOnce)((TraversableLike)((TraversableLike)dsc.inputsByRole().values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaRecipeExecutor$.$anonfun$executeFunction$1(x$3)))).map((Function1 & Serializable & scala.Serializable)in -> {
            MODULE$.logger().info((Object)new StringBuilder(21).append("Opening: ").append(in.fullName()).append(" with parts ").append(in.partitions()).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)in.smartName()), (Object)dsc.internalGetDataFrame(sqlContext2, in.fullName(), in.partitions(), dsc.internalGetDataFrame$default$4(), dsc.internalGetDataFrame$default$5()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        inputs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaRecipeExecutor$.$anonfun$executeFunction$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            SparkScalaRecipeExecutor$.$anonfun$executeFunction$4(x$4);
            return BoxedUnit.UNIT;
        });
        this.logger().info((Object)"Executing recipe function");
        Map outputs = ((MultiTransformer)mainClass.getConstructor(new Class[0]).newInstance(new Object[0])).transform(inputs, sparkContext2, sqlContext2, (DataikuSparkContext)dsc);
        this.logger().info((Object)"Saving output datasets");
        Seq outs = ((TraversableOnce)((TraversableLike)dsc.outputsByRole().values().flatten((Function1)Predef$.MODULE$.$conforms())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaRecipeExecutor$.$anonfun$executeFunction$5(x$5)))).toSeq();
        outputs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaRecipeExecutor$.$anonfun$executeFunction$6(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            SparkScalaRecipeExecutor$.$anonfun$executeFunction$7(outs, dsc, x$7);
            return BoxedUnit.UNIT;
        });
        Set set = outputs.keySet();
        Seq missing = (Seq)((TraversableLike)outs.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.smartName(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)));
        missing.foreach((Function1 & Serializable & scala.Serializable)smartName -> {
            SparkScalaRecipeExecutor$.$anonfun$executeFunction$11(smartName);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$compile$1(StoreReporter.Info info) {
        MODULE$.logger().info((Object)new StringBuilder(13).append("Compilation: ").append(info.toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$compile$3(JarOutputStream jar$1, File f) {
        JarEntry entry = new JarEntry(f.getName());
        entry.setTime(f.lastModified());
        jar$1.putNextEntry(entry);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        byte[] buffer = new byte[1024];
        int c = in.read(buffer);
        while (c != -1) {
            jar$1.write(buffer, 0, c);
            c = in.read(buffer);
        }
        jar$1.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$compile$2(File[] classFiles$1, JarOutputStream jar) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classFiles$1)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            SparkScalaRecipeExecutor$.$anonfun$compile$3(jar, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$executeFunction$1(FlowInput x$3) {
        Enumeration.Value value = x$3.kind();
        Enumeration.Value value2 = FlowComputableType$.MODULE$.Dataset();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$executeFunction$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$executeFunction$4(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            String smartName = (String)tuple2._1();
            Dataset df = (Dataset)tuple2._2();
            com.dataiku.dip.utils.package$.MODULE$.registerTempTableProperly((Dataset<Row>)df, smartName);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$executeFunction$5(FlowOutput x$5) {
        Enumeration.Value value = x$5.kind();
        Enumeration.Value value2 = FlowComputableType$.MODULE$.Dataset();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$executeFunction$6(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$executeFunction$8(String smartName$1, FlowOutput x$6) {
        String string = x$6.smartName();
        String string2 = smartName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$executeFunction$7(Seq outs$1, DataikuSparkRecipeContext dsc$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            String smartName = (String)tuple2._1();
            Dataset df = (Dataset)tuple2._2();
            Option option = outs$1.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaRecipeExecutor$.$anonfun$executeFunction$8(smartName, x$6)));
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(48).append("Cannot write to ").append(smartName).append(", not specified as recipe output").toString());
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            FlowOutput out = (FlowOutput)some.value();
            dsc$1.save(smartName, (Dataset<Row>)df, (Option<String>)Option$.MODULE$.apply((Object)out.partition()), (Option<Enumeration.Value>)new Some((Object)out.writeMode()), true);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$executeFunction$11(String smartName) {
        MODULE$.logger().warn((Object)new StringBuilder(70).append("Dataset ").append(smartName).append(" was not returned by the recipe function, and thus not written").toString());
    }

    private SparkScalaRecipeExecutor$() {
        MODULE$ = this;
        this.defaultClassName = "CustomScalaRecipe";
        this.logger = Logger.getLogger((String)"dku.spark.recipe.scala");
    }
}

