/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.codeenvs;

import com.dataiku.dip.code.APINodeCodeEnvImporter;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeEnvsService {
    public static final String PYTHON_ENV_LIVE = "python-env-live";
    public static final String R_ENV_LIVE = "R-env-live";
    @Autowired
    private LambdaContext lambdaContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.codeenvs");

    public File createCodeEnv(String codeEnvDir, String codeEnvLanguage) throws Exception {
        CodeEnvModel.EnvLang envLang;
        File cacheFolder;
        File exportedEnvDir = new File(codeEnvDir);
        if (codeEnvLanguage.equals("python")) {
            cacheFolder = this.lambdaContext.getGlobalPythonCodeEnvFile();
            envLang = CodeEnvModel.EnvLang.PYTHON;
        } else if (codeEnvLanguage.equals("R")) {
            cacheFolder = this.lambdaContext.getGlobalRCodeEnvFile();
            envLang = CodeEnvModel.EnvLang.R;
        } else {
            throw new UnsupportedOperationException("Unsupported code env language " + codeEnvLanguage);
        }
        return new APINodeCodeEnvImporter().importManagedEnv(envLang, exportedEnvDir, cacheFolder, false, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE, CodeEnvModel.EnvImportSpecificationMode.SPECIFIED);
    }

    public File registerCodeEnv(String codeEnvLanguage, String exportedDescPath, String buildEnvPath) throws Exception {
        CodeEnvModel.EnvLang envLang;
        File cacheFolder;
        File exportedEnvDir = new File(exportedDescPath);
        File builtEnvDir = new File(buildEnvPath);
        if (codeEnvLanguage.equals("python")) {
            cacheFolder = this.lambdaContext.getGlobalPythonCodeEnvFile();
            envLang = CodeEnvModel.EnvLang.PYTHON;
        } else if (codeEnvLanguage.equals("R")) {
            cacheFolder = this.lambdaContext.getGlobalRCodeEnvFile();
            envLang = CodeEnvModel.EnvLang.R;
        } else {
            throw new UnsupportedOperationException("Unsupported code env language " + codeEnvLanguage);
        }
        return new APINodeCodeEnvImporter().registerManagedEnv(envLang, cacheFolder, exportedEnvDir, builtEnvDir, CodeEnvModel.EnvImportSpecificationMode.SPECIFIED);
    }

    public CodeEnvCleanupResult cleanUnused() throws IOException {
        List<Object> classicalCacheEntries;
        List<Object> globalCacheEntries;
        CodeEnvCleanupResult res = new CodeEnvCleanupResult();
        logger.info((Object)"Cleaning unused code environments");
        Path servicesPath = this.lambdaContext.getFile(new String[]{"services"}).toPath();
        Set liveCodeEnvPaths = Files.walk(servicesPath, 5, new FileVisitOption[0]).filter(Files::isSymbolicLink).filter(path -> servicesPath.relativize((Path)path).getNameCount() == 5).filter(path -> {
            String fileName = path.getFileName().toString();
            return StringUtils.equals((String)fileName, (String)PYTHON_ENV_LIVE) || StringUtils.equals((String)fileName, (String)R_ENV_LIVE);
        }).collect(Collectors.toSet());
        logger.infoV("Found the following code envs in endpoints:\n - %s", new Object[]{String.join((CharSequence)"\n - ", (CharSequence[])liveCodeEnvPaths.stream().map(Path::toString).toArray(String[]::new))});
        HashSet<Path> usedCacheEntries = new HashSet<Path>();
        for (Path curLiveCodeEnvPath : liveCodeEnvPaths) {
            try {
                Path resolvedLink = Files.readSymbolicLink(curLiveCodeEnvPath);
                usedCacheEntries.add(resolvedLink);
                logger.infoV("%s -> %s", new Object[]{curLiveCodeEnvPath, resolvedLink});
                res.usedCacheEntries.put((Object)resolvedLink.toAbsolutePath().toString(), (Object)curLiveCodeEnvPath.toAbsolutePath().toString());
            }
            catch (IOException ioe) {
                logger.errorV("Error while resolving symbolic link %s", new Object[]{curLiveCodeEnvPath.toAbsolutePath().toString()});
            }
        }
        File globalCacheFolderRoot = this.lambdaContext.getFile(new String[]{"global-code-envs-cache"});
        if (globalCacheFolderRoot.exists() && globalCacheFolderRoot.isDirectory()) {
            Path globalCachePath = globalCacheFolderRoot.toPath();
            globalCacheEntries = Files.walk(globalCachePath, 3, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> globalCachePath.relativize((Path)path).getNameCount() == 3).collect(Collectors.toList());
            if (globalCacheEntries.isEmpty()) {
                logger.info((Object)"No entry found in global-code-envs-cache!");
            } else {
                logger.infoV("Found the following entries in global-code-envs-cache:\n - %s", new Object[]{String.join((CharSequence)"\n - ", (CharSequence[])globalCacheEntries.stream().map(Path::toString).toArray(String[]::new))});
            }
        } else {
            logger.infoV("No global cache directory found %s", new Object[]{globalCacheFolderRoot.getAbsolutePath()});
            globalCacheEntries = new ArrayList();
        }
        File classicalCacheFolderRoot = this.lambdaContext.getFile(new String[]{"code-envs-cache"});
        if (classicalCacheFolderRoot.exists() && classicalCacheFolderRoot.isDirectory()) {
            Path classicalCachePath = classicalCacheFolderRoot.toPath();
            classicalCacheEntries = Files.walk(classicalCachePath, 5, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> classicalCachePath.relativize((Path)path).getNameCount() == 5).collect(Collectors.toList());
            if (classicalCacheEntries.isEmpty()) {
                logger.info((Object)"No entry found in code-envs-cache!");
            } else {
                logger.infoV("Found the following entries in code-envs-cache:\n - %s", new Object[]{String.join((CharSequence)"\n - ", (CharSequence[])classicalCacheEntries.stream().map(Path::toString).toArray(String[]::new))});
            }
        } else {
            logger.infoV("No classical cache directory found %s", new Object[]{classicalCacheFolderRoot.getAbsolutePath()});
            classicalCacheEntries = new ArrayList();
        }
        Set cacheEntries = Stream.concat(globalCacheEntries.stream(), classicalCacheEntries.stream()).collect(Collectors.toSet());
        SetUtils.SetView difference = SetUtils.difference(cacheEntries, usedCacheEntries);
        if (difference.isEmpty()) {
            logger.info((Object)"No code env to remove from cache!");
        } else {
            for (Path toRemove : difference) {
                logger.infoV("Removing unused entry in cache: %s", new Object[]{toRemove.toAbsolutePath().toString()});
                res.deletedCacheEntries.add(toRemove.toAbsolutePath().toString());
                try {
                    DKUFileUtils.deleteDirectory((File)toRemove.toFile());
                }
                catch (IOException ioe) {
                    logger.errorV("Error while removing unused code env in cache %s", new Object[]{toRemove.toAbsolutePath().toString()});
                }
            }
        }
        Collections.sort(res.deletedCacheEntries);
        return res;
    }

    public static class CodeEnvCleanupResult {
        public TreeMultimap<String, String> usedCacheEntries = TreeMultimap.create();
        public List<String> deletedCacheEntries = new ArrayList<String>();

        static {
            JSON.registerAdapter(CodeEnvCleanupResult.class, (Object)new CodeEnvCleanupResultSerializer());
        }
    }

    public static class CodeEnvCleanupResultSerializer
    implements JSON.Adapter<CodeEnvCleanupResult> {
        public CodeEnvCleanupResult deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            assert (false) : "Not implemented";
            return null;
        }

        public JsonElement serialize(CodeEnvCleanupResult codeEnvCleanupResult, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject ret = new JsonObject();
            ret.addProperty("usedCacheEntries", codeEnvCleanupResult.usedCacheEntries.toString());
            ret.addProperty("deletedCacheEntries", codeEnvCleanupResult.deletedCacheEntries.toString());
            return ret;
        }
    }
}

