/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.retry;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksError;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.retry.RetryStrategy;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.retry.RetryUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IdempotentRequestRetryStrategy
implements RetryStrategy {
    private static final Set<Class<? extends RuntimeException>> NON_RETRIABLE_EXCEPTIONS = new HashSet<Class>(Arrays.asList(IllegalArgumentException.class, IllegalStateException.class, UnsupportedOperationException.class, IndexOutOfBoundsException.class, NullPointerException.class, ClassCastException.class, NumberFormatException.class, ArrayIndexOutOfBoundsException.class, ArrayStoreException.class, ArithmeticException.class, NegativeArraySizeException.class));
    private static final Set<Integer> NON_RETRIABLE_HTTP_CODES = new HashSet<Integer>(Arrays.asList(400, 401, 403, 404, 405, 409, 410, 411, 412, 413, 414, 415, 416));

    @Override
    public boolean isRetriable(DatabricksError databricksError) {
        if (RetryUtils.isCausedByTransientError(databricksError)) {
            return true;
        }
        if (this.isNonRetriableException(databricksError)) {
            return false;
        }
        return !this.isNonRetriableHttpCode(databricksError);
    }

    private boolean isNonRetriableException(DatabricksError databricksError) {
        if (databricksError.getCause() == null) {
            return false;
        }
        return NON_RETRIABLE_EXCEPTIONS.contains(databricksError.getCause().getClass());
    }

    private boolean isNonRetriableHttpCode(DatabricksError databricksError) {
        return NON_RETRIABLE_HTTP_CODES.contains(databricksError.getStatusCode());
    }
}

