/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksException;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.BaseJob;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.BaseRun;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.CancelAllRuns;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.CancelRun;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.CreateJob;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.CreateResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.DeleteJob;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.DeleteRun;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ExportRunOutput;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ExportRunRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetJobPermissionLevelsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetJobPermissionLevelsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetJobPermissionsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetJobRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetRunOutputRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.GetRunRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.Job;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.JobPermissions;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.JobPermissionsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.JobSettings;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.JobsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.JobsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ListJobsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ListJobsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ListRunsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ListRunsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RepairRun;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RepairRunResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.ResetJob;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.Run;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RunLifeCycleState;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RunNow;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RunNowResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.RunOutput;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.SubmitRun;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.SubmitRunResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.jobs.UpdateJob;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class JobsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(JobsAPI.class);
    private final JobsService impl;

    public JobsAPI(ApiClient apiClient) {
        this.impl = new JobsImpl(apiClient);
    }

    public JobsAPI(JobsService mock) {
        this.impl = mock;
    }

    public Run waitGetRunJobTerminatedOrSkipped(Long runId) throws TimeoutException {
        return this.waitGetRunJobTerminatedOrSkipped(runId, Duration.ofMinutes(20L), null);
    }

    public Run waitGetRunJobTerminatedOrSkipped(Long runId, Duration timeout, Consumer<Run> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<RunLifeCycleState> targetStates = Arrays.asList(RunLifeCycleState.TERMINATED, RunLifeCycleState.SKIPPED);
        List<RunLifeCycleState> failureStates = Arrays.asList(RunLifeCycleState.INTERNAL_ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            Run poll = this.getRun(new GetRunRequest().setRunId(runId));
            RunLifeCycleState status = poll.getState().getLifeCycleState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getState() != null) {
                statusMessage = poll.getState().getStateMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach TERMINATED or SKIPPED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("runId=%s", runId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public void cancelAllRuns(CancelAllRuns request) {
        this.impl.cancelAllRuns(request);
    }

    public Wait<Run, Void> cancelRun(long runId) {
        return this.cancelRun(new CancelRun().setRunId(runId));
    }

    public Wait<Run, Void> cancelRun(CancelRun request) {
        this.impl.cancelRun(request);
        return new Wait<Run, Void>((timeout, callback) -> this.waitGetRunJobTerminatedOrSkipped(request.getRunId(), timeout, callback));
    }

    public CreateResponse create(CreateJob request) {
        return this.impl.create(request);
    }

    public void delete(long jobId) {
        this.delete(new DeleteJob().setJobId(jobId));
    }

    public void delete(DeleteJob request) {
        this.impl.delete(request);
    }

    public void deleteRun(long runId) {
        this.deleteRun(new DeleteRun().setRunId(runId));
    }

    public void deleteRun(DeleteRun request) {
        this.impl.deleteRun(request);
    }

    public ExportRunOutput exportRun(long runId) {
        return this.exportRun(new ExportRunRequest().setRunId(runId));
    }

    public ExportRunOutput exportRun(ExportRunRequest request) {
        return this.impl.exportRun(request);
    }

    public Job get(long jobId) {
        return this.get(new GetJobRequest().setJobId(jobId));
    }

    public Job get(GetJobRequest request) {
        return this.impl.get(request);
    }

    public GetJobPermissionLevelsResponse getPermissionLevels(String jobId) {
        return this.getPermissionLevels(new GetJobPermissionLevelsRequest().setJobId(jobId));
    }

    public GetJobPermissionLevelsResponse getPermissionLevels(GetJobPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public JobPermissions getPermissions(String jobId) {
        return this.getPermissions(new GetJobPermissionsRequest().setJobId(jobId));
    }

    public JobPermissions getPermissions(GetJobPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Run getRun(long runId) {
        return this.getRun(new GetRunRequest().setRunId(runId));
    }

    public Run getRun(GetRunRequest request) {
        return this.impl.getRun(request);
    }

    public RunOutput getRunOutput(long runId) {
        return this.getRunOutput(new GetRunOutputRequest().setRunId(runId));
    }

    public RunOutput getRunOutput(GetRunOutputRequest request) {
        return this.impl.getRunOutput(request);
    }

    public Iterable<BaseJob> list(ListJobsRequest request) {
        return new Paginator(request, this.impl::list, ListJobsResponse::getJobs, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<BaseRun> listRuns(ListRunsRequest request) {
        return new Paginator(request, this.impl::listRuns, ListRunsResponse::getRuns, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Wait<Run, RepairRunResponse> repairRun(long runId) {
        return this.repairRun(new RepairRun().setRunId(runId));
    }

    public Wait<Run, RepairRunResponse> repairRun(RepairRun request) {
        RepairRunResponse response = this.impl.repairRun(request);
        return new Wait<Run, RepairRunResponse>((timeout, callback) -> this.waitGetRunJobTerminatedOrSkipped(request.getRunId(), timeout, callback), response);
    }

    public void reset(long jobId, JobSettings newSettings) {
        this.reset(new ResetJob().setJobId(jobId).setNewSettings(newSettings));
    }

    public void reset(ResetJob request) {
        this.impl.reset(request);
    }

    public Wait<Run, RunNowResponse> runNow(long jobId) {
        return this.runNow(new RunNow().setJobId(jobId));
    }

    public Wait<Run, RunNowResponse> runNow(RunNow request) {
        RunNowResponse response = this.impl.runNow(request);
        return new Wait<Run, RunNowResponse>((timeout, callback) -> this.waitGetRunJobTerminatedOrSkipped(response.getRunId(), timeout, callback), response);
    }

    public JobPermissions setPermissions(String jobId) {
        return this.setPermissions(new JobPermissionsRequest().setJobId(jobId));
    }

    public JobPermissions setPermissions(JobPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public Wait<Run, SubmitRunResponse> submit(SubmitRun request) {
        SubmitRunResponse response = this.impl.submit(request);
        return new Wait<Run, SubmitRunResponse>((timeout, callback) -> this.waitGetRunJobTerminatedOrSkipped(response.getRunId(), timeout, callback), response);
    }

    public void update(long jobId) {
        this.update(new UpdateJob().setJobId(jobId));
    }

    public void update(UpdateJob request) {
        this.impl.update(request);
    }

    public JobPermissions updatePermissions(String jobId) {
        return this.updatePermissions(new JobPermissionsRequest().setJobId(jobId));
    }

    public JobPermissions updatePermissions(JobPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public JobsService impl() {
        return this.impl;
    }
}

