/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.types.DataTypeJsonSerDe;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.StructField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Evolving
public final class StructType
extends DataType {
    private final Map<String, Tuple2<StructField, Integer>> nameToFieldAndOrdinal;
    private final List<StructField> fields;
    private final List<String> fieldNames;

    public StructType() {
        this(new ArrayList<StructField>());
    }

    public StructType(List<StructField> list) {
        this.fields = list;
        this.fieldNames = list.stream().map(structField -> structField.getName()).collect(Collectors.toList());
        this.nameToFieldAndOrdinal = new HashMap<String, Tuple2<StructField, Integer>>();
        for (int i = 0; i < list.size(); ++i) {
            this.nameToFieldAndOrdinal.put(list.get(i).getName(), new Tuple2<StructField, Integer>(list.get(i), i));
        }
    }

    public StructType add(StructField structField) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>(this.fields);
        arrayList.add(structField);
        return new StructType(arrayList);
    }

    public StructType add(String string, DataType dataType) {
        return this.add(new StructField(string, dataType, true));
    }

    public StructType add(String string, DataType dataType, boolean bl) {
        return this.add(new StructField(string, dataType, bl));
    }

    public StructType add(String string, DataType dataType, FieldMetadata fieldMetadata) {
        return this.add(new StructField(string, dataType, true, fieldMetadata));
    }

    public StructType add(String string, DataType dataType, boolean bl, FieldMetadata fieldMetadata) {
        return this.add(new StructField(string, dataType, bl, fieldMetadata));
    }

    public List<StructField> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public int length() {
        return this.fields.size();
    }

    public int indexOf(String string) {
        return this.fieldNames.indexOf(string);
    }

    public StructField get(String string) {
        return (StructField)this.nameToFieldAndOrdinal.get((Object)string)._1;
    }

    public StructField at(int n) {
        return this.fields.get(n);
    }

    public Column column(int n) {
        StructField structField = this.at(n);
        return new Column(structField.getName());
    }

    public String toJson() {
        return DataTypeJsonSerDe.serializeStructType(this);
    }

    @Override
    public boolean equivalent(DataType dataType) {
        if (!(dataType instanceof StructType)) {
            return false;
        }
        StructType structType = (StructType)dataType;
        return structType.length() == this.length() && IntStream.range(0, this.length()).mapToObj(n -> structType.at(n).getDataType().equivalent(this.at(n).getDataType())).allMatch(bl -> bl);
    }

    @Override
    public String toString() {
        return String.format("struct(%s)", this.fields.stream().map(StructField::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructType structType = (StructType)object;
        return this.nameToFieldAndOrdinal.equals(structType.nameToFieldAndOrdinal) && this.fields.equals(structType.fields) && this.fieldNames.equals(structType.fieldNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nameToFieldAndOrdinal, this.fields, this.fieldNames);
    }
}

