/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.featurestore.FeatureStoreService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/feature-store"})
public class PublicAPIFeatureStoreController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private FeatureStoreService featureStoreService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;

    @AuditedCall(value={"msgType", "list-feature-groups", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/feature-groups"}, method={RequestMethod.GET})
    public List<FeatureStoreService.FeatureGroupId> list(HttpServletRequest req, @Nullable String explainDocId, @Nullable String explainDocType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List list = this.featureStoreService.getFeatureGroups(authCtx, explainDocId, explainDocType);
            return list;
        }
    }
}

