/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public class KeywordMarkerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "keywordMarker";
    public static final String PROTECTED_TOKENS = "protected";
    public static final String PATTERN = "pattern";
    private final String wordFiles;
    private final String stringPattern;
    private final boolean ignoreCase;
    private Pattern pattern;
    private CharArraySet protectedWords;

    public KeywordMarkerFilterFactory(Map<String, String> args2) {
        super(args2);
        this.wordFiles = this.get(args2, PROTECTED_TOKENS);
        this.stringPattern = this.get(args2, PATTERN);
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public KeywordMarkerFilterFactory() {
        throw KeywordMarkerFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
        }
        if (this.stringPattern != null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.stringPattern, 66) : Pattern.compile(this.stringPattern);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.pattern != null) {
            input = new PatternKeywordMarkerFilter(input, this.pattern);
        }
        if (this.protectedWords != null) {
            input = new SetKeywordMarkerFilter(input, this.protectedWords);
        }
        return input;
    }
}

