/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import java.util.Map;

public class LimitTokenCountFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "limitTokenCount";
    public static final String MAX_TOKEN_COUNT_KEY = "maxTokenCount";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    final int maxTokenCount;
    final boolean consumeAllTokens;

    public LimitTokenCountFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxTokenCount = this.requireInt(args2, MAX_TOKEN_COUNT_KEY);
        this.consumeAllTokens = this.getBoolean(args2, CONSUME_ALL_TOKENS_KEY, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public LimitTokenCountFilterFactory() {
        throw LimitTokenCountFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenCountFilter(input, this.maxTokenCount, this.consumeAllTokens);
    }
}

