/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.BinaryRangeDocValuesField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LongRange;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LongRangeSlowRangeQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.document.RangeFieldQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;

public class LongRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final long[] min;
    final long[] max;

    public LongRangeDocValuesField(String field, long[] min2, long[] max) {
        super(field, LongRange.encode(min2, max), min2.length, 8);
        LongRangeDocValuesField.checkArgs(min2, max);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    public long getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public long getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, long[] min2, long[] max, RangeFieldQuery.QueryType queryType) {
        LongRangeDocValuesField.checkArgs(min2, max);
        return new LongRangeSlowRangeQuery(field, min2, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, long[] min2, long[] max) {
        return LongRangeDocValuesField.newSlowRangeQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(long[] min2, long[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min2.length; ++i) {
            if (min2[i] <= max[i]) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

