/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.BaseTermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ImpactsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.OrdTermState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRefBuilder;
import java.io.IOException;

class SortedDocValuesTermsEnum
extends BaseTermsEnum {
    private final SortedDocValues values;
    private int currentOrd = -1;
    private final BytesRefBuilder scratch;

    public SortedDocValuesTermsEnum(SortedDocValues values2) {
        this.values = values2;
        this.scratch = new BytesRefBuilder();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        int ord = this.values.lookupTerm(text);
        if (ord >= 0) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text);
            return TermsEnum.SeekStatus.FOUND;
        }
        this.currentOrd = -ord - 1;
        if (this.currentOrd == this.values.getValueCount()) {
            return TermsEnum.SeekStatus.END;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        int ord = this.values.lookupTerm(text);
        if (ord >= 0) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text);
            return true;
        }
        return false;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        assert (ord >= 0L && ord < (long)this.values.getValueCount());
        this.currentOrd = (int)ord;
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
    }

    @Override
    public BytesRef next() throws IOException {
        ++this.currentOrd;
        if (this.currentOrd >= this.values.getValueCount()) {
            return null;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return this.scratch.get();
    }

    @Override
    public BytesRef term() throws IOException {
        return this.scratch.get();
    }

    @Override
    public long ord() throws IOException {
        return this.currentOrd;
    }

    @Override
    public int docFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalTermFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        assert (state != null && state instanceof OrdTermState);
        this.seekExact(((OrdTermState)state).ord);
    }

    @Override
    public TermState termState() throws IOException {
        OrdTermState state = new OrdTermState();
        state.ord = this.currentOrd;
        return state;
    }
}

