/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.CollectionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead1;
    final DocIdSetIterator lead2;
    final DocIdSetIterator[] others;

    static void addScorer(Scorer scorer, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = scorer.twoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionDISI.addIterator(scorer.iterator(), allIterators, twoPhaseIterators);
        }
    }

    static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhase = TwoPhaseIterator.unwrap(disi);
        if (twoPhase != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhase, allIterators, twoPhaseIterators);
        } else if (disi.getClass() == ConjunctionDISI.class) {
            ConjunctionDISI conjunction = (ConjunctionDISI)disi;
            allIterators.add(conjunction.lead1);
            allIterators.add(conjunction.lead2);
            Collections.addAll(allIterators, conjunction.others);
        } else if (disi.getClass() == BitSetConjunctionDISI.class) {
            BitSetConjunctionDISI conjunction = (BitSetConjunctionDISI)disi;
            allIterators.add(conjunction.lead);
            Collections.addAll(allIterators, conjunction.bitSetIterators);
        } else {
            allIterators.add(disi);
        }
    }

    static void addTwoPhaseIterator(TwoPhaseIterator twoPhaseIter, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        ConjunctionDISI.addIterator(twoPhaseIter.approximation(), allIterators, twoPhaseIterators);
        if (twoPhaseIter.getClass() == ConjunctionTwoPhaseIterator.class) {
            Collections.addAll(twoPhaseIterators, ((ConjunctionTwoPhaseIterator)twoPhaseIter).twoPhaseIterators);
        } else {
            twoPhaseIterators.add(twoPhaseIter);
        }
    }

    static DocIdSetIterator createConjunction(List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        int curDoc = allIterators.size() > 0 ? allIterators.get(0).docID() : twoPhaseIterators.get((int)0).approximation.docID();
        long minCost = Long.MAX_VALUE;
        for (DocIdSetIterator allIterator : allIterators) {
            if (allIterator.docID() != curDoc) {
                ConjunctionDISI.throwSubIteratorsNotOnSameDocument();
            }
            minCost = Math.min(allIterator.cost(), minCost);
        }
        for (TwoPhaseIterator it : twoPhaseIterators) {
            if (it.approximation().docID() == curDoc) continue;
            ConjunctionDISI.throwSubIteratorsNotOnSameDocument();
        }
        ArrayList<BitSetIterator> bitSetIterators = new ArrayList<BitSetIterator>();
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (DocIdSetIterator iterator2 : allIterators) {
            if (iterator2 instanceof BitSetIterator && iterator2.cost() > minCost) {
                bitSetIterators.add((BitSetIterator)iterator2);
                continue;
            }
            iterators.add(iterator2);
        }
        DocIdSetIterator disi = iterators.size() == 1 ? (DocIdSetIterator)iterators.get(0) : new ConjunctionDISI(iterators);
        if (bitSetIterators.size() > 0) {
            disi = new BitSetConjunctionDISI(disi, bitSetIterators);
        }
        if (!twoPhaseIterators.isEmpty()) {
            disi = TwoPhaseIterator.asDocIdSetIterator(new ConjunctionTwoPhaseIterator(disi, twoPhaseIterators));
        }
        return disi;
    }

    private static void throwSubIteratorsNotOnSameDocument() {
        throw new IllegalArgumentException("Sub-iterators of ConjunctionDISI are not on the same document!");
    }

    private ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        assert (iterators.size() >= 2);
        CollectionUtil.timSort(iterators, (o1, o2) -> Long.compare(o1.cost(), o2.cost()));
        this.lead1 = iterators.get(0);
        this.lead2 = iterators.get(1);
        this.others = iterators.subList(2, iterators.size()).toArray(new DocIdSetIterator[0]);
    }

    private int doNext(int doc) throws IOException {
        block0: while (true) {
            assert (doc == this.lead1.docID());
            int next2 = this.lead2.advance(doc);
            if (next2 != doc && next2 != (doc = this.lead1.advance(next2))) continue;
            for (DocIdSetIterator other : this.others) {
                int next;
                if (other.docID() >= doc || (next = other.advance(doc)) <= doc) continue;
                doc = this.lead1.advance(next);
                continue block0;
            }
            break;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        assert (this.assertItersOnSameDoc()) : "Sub-iterators of ConjunctionDISI are not one the same document!";
        return this.doNext(this.lead1.advance(target));
    }

    @Override
    public int docID() {
        return this.lead1.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        assert (this.assertItersOnSameDoc()) : "Sub-iterators of ConjunctionDISI are not on the same document!";
        return this.doNext(this.lead1.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }

    private boolean assertItersOnSameDoc() {
        int curDoc = this.lead1.docID();
        boolean iteratorsOnTheSameDoc = this.lead2.docID() == curDoc;
        for (int i = 0; i < this.others.length && iteratorsOnTheSameDoc; ++i) {
            iteratorsOnTheSameDoc = iteratorsOnTheSameDoc && this.others[i].docID() == curDoc;
        }
        return iteratorsOnTheSameDoc;
    }

    private static final class ConjunctionTwoPhaseIterator
    extends TwoPhaseIterator {
        private final TwoPhaseIterator[] twoPhaseIterators;
        private final float matchCost;

        private ConjunctionTwoPhaseIterator(DocIdSetIterator approximation, List<? extends TwoPhaseIterator> twoPhaseIterators) {
            super(approximation);
            assert (twoPhaseIterators.size() > 0);
            CollectionUtil.timSort(twoPhaseIterators, (o1, o2) -> Float.compare(o1.matchCost(), o2.matchCost()));
            this.twoPhaseIterators = twoPhaseIterators.toArray(new TwoPhaseIterator[twoPhaseIterators.size()]);
            float totalMatchCost = 0.0f;
            for (TwoPhaseIterator twoPhaseIterator : twoPhaseIterators) {
                totalMatchCost += twoPhaseIterator.matchCost();
            }
            this.matchCost = totalMatchCost;
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator : this.twoPhaseIterators) {
                if (twoPhaseIterator.matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }

    private static class BitSetConjunctionDISI
    extends DocIdSetIterator {
        private final DocIdSetIterator lead;
        private final BitSetIterator[] bitSetIterators;
        private final BitSet[] bitSets;
        private final int minLength;

        BitSetConjunctionDISI(DocIdSetIterator lead, Collection<BitSetIterator> bitSetIterators) {
            this.lead = lead;
            assert (bitSetIterators.size() > 0);
            this.bitSetIterators = bitSetIterators.toArray(new BitSetIterator[0]);
            ArrayUtil.timSort(this.bitSetIterators, (a, b) -> Long.compare(a.cost(), b.cost()));
            this.bitSets = new BitSet[this.bitSetIterators.length];
            int minLen = Integer.MAX_VALUE;
            for (int i = 0; i < this.bitSetIterators.length; ++i) {
                BitSet bitSet;
                this.bitSets[i] = bitSet = this.bitSetIterators[i].getBitSet();
                minLen = Math.min(minLen, bitSet.length());
            }
            this.minLength = minLen;
        }

        @Override
        public int docID() {
            return this.lead.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            assert (this.assertItersOnSameDoc()) : "Sub-iterators of ConjunctionDISI are not on the same document!";
            return this.doNext(this.lead.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.assertItersOnSameDoc()) : "Sub-iterators of ConjunctionDISI are not on the same document!";
            return this.doNext(this.lead.advance(target));
        }

        private int doNext(int doc) throws IOException {
            while (true) {
                block6: {
                    if (doc >= this.minLength) {
                        if (doc != Integer.MAX_VALUE) {
                            this.lead.advance(Integer.MAX_VALUE);
                        }
                        return Integer.MAX_VALUE;
                    }
                    for (BitSet bitSet : this.bitSets) {
                        if (bitSet.get(doc)) {
                            continue;
                        }
                        break block6;
                    }
                    for (BitSetIterator iterator2 : this.bitSetIterators) {
                        iterator2.setDocId(doc);
                    }
                    return doc;
                }
                doc = this.lead.nextDoc();
            }
        }

        @Override
        public long cost() {
            return this.lead.cost();
        }

        private boolean assertItersOnSameDoc() {
            int curDoc = this.lead.docID();
            boolean iteratorsOnTheSameDoc = true;
            for (int i = 0; i < this.bitSetIterators.length && iteratorsOnTheSameDoc; ++i) {
                iteratorsOnTheSameDoc = iteratorsOnTheSameDoc && this.bitSetIterators[i].docID() == curDoc;
            }
            return iteratorsOnTheSameDoc;
        }
    }
}

