/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.similarities;

import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.BasicStats;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.Independence;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.SimilarityBase;

public class DFISimilarity
extends SimilarityBase {
    private final Independence independence;

    public DFISimilarity(Independence independenceMeasure) {
        this(independenceMeasure, true);
    }

    public DFISimilarity(Independence independenceMeasure, boolean discountOverlaps) {
        super(discountOverlaps);
        this.independence = independenceMeasure;
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        double expected = (double)(stats.getTotalTermFreq() + 1L) * docLen / (double)(stats.getNumberOfFieldTokens() + 1L);
        if (freq <= expected) {
            return 0.0;
        }
        double measure = this.independence.score(freq, expected);
        return stats.getBoost() * DFISimilarity.log2(measure + 1.0);
    }

    public Independence getIndependence() {
        return this.independence;
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        double expected = (double)(stats.getTotalTermFreq() + 1L) * docLen / (double)(stats.getNumberOfFieldTokens() + 1L);
        if (freq.getValue().doubleValue() <= expected) {
            return Explanation.match((Number)Float.valueOf(0.0f), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), equals to 0", new Explanation[0]);
        }
        Explanation explExpected = Explanation.match((Number)Float.valueOf((float)expected), "expected, computed as (F + 1) * dl / (T + 1) from:", Explanation.match((Number)stats.getTotalTermFreq(), "F, total number of occurrences of term across all docs", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]), Explanation.match((Number)stats.getNumberOfFieldTokens(), "T, total number of tokens in the field", new Explanation[0]));
        double measure = this.independence.score(freq.getValue().doubleValue(), expected);
        Explanation explMeasure = Explanation.match((Number)Float.valueOf((float)measure), "measure, computed as independence.score(freq, expected) from:", freq, explExpected);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed as boost * log2(measure + 1) from:", Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "boost, query boost", new Explanation[0]), explMeasure);
    }

    @Override
    public String toString() {
        return "DFI(" + this.independence + ")";
    }
}

