/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.UHComponents;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import java.io.IOException;

public abstract class AnalysisOffsetStrategy
extends FieldOffsetStrategy {
    protected final Analyzer analyzer;

    public AnalysisOffsetStrategy(UHComponents components, Analyzer analyzer) {
        super(components);
        this.analyzer = analyzer;
        if (analyzer.getOffsetGap(this.getField()) != 1) {
            throw new IllegalArgumentException("offset gap of the provided analyzer should be 1 (field " + this.getField() + ")");
        }
    }

    @Override
    public final UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }

    protected TokenStream tokenStream(String content) throws IOException {
        int splitCharIdx = content.indexOf(0);
        if (splitCharIdx == -1) {
            return this.analyzer.tokenStream(this.getField(), content);
        }
        TokenStream subTokenStream = this.analyzer.tokenStream(this.getField(), content.substring(0, splitCharIdx));
        return new MultiValueTokenStream(subTokenStream, this.getField(), this.analyzer, content, '\u0000', splitCharIdx);
    }

    private static final class MultiValueTokenStream
    extends TokenFilter {
        private final String fieldName;
        private final Analyzer indexAnalyzer;
        private final String content;
        private final char splitChar;
        private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
        private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
        private int startValIdx = 0;
        private int endValIdx;
        private int remainingPosInc = 0;

        private MultiValueTokenStream(TokenStream subTokenStream, String fieldName, Analyzer indexAnalyzer, String content, char splitChar, int splitCharIdx) {
            super(subTokenStream);
            this.fieldName = fieldName;
            this.indexAnalyzer = indexAnalyzer;
            this.content = content;
            this.splitChar = splitChar;
            this.endValIdx = splitCharIdx;
        }

        @Override
        public void reset() throws IOException {
            if (this.startValIdx != 0) {
                throw new IllegalStateException("This TokenStream wasn't developed to be re-used.");
            }
            super.reset();
        }

        @Override
        public boolean incrementToken() throws IOException {
            while (true) {
                TokenStream tokenStream;
                if (this.input.incrementToken()) {
                    if (this.remainingPosInc > 0) {
                        this.posIncAtt.setPositionIncrement(this.remainingPosInc + this.posIncAtt.getPositionIncrement());
                        this.remainingPosInc = 0;
                    }
                    this.offsetAtt.setOffset(this.startValIdx + this.offsetAtt.startOffset(), this.startValIdx + this.offsetAtt.endOffset());
                    return true;
                }
                if (this.endValIdx == this.content.length()) {
                    return false;
                }
                this.input.end();
                this.remainingPosInc += this.posIncAtt.getPositionIncrement();
                this.input.close();
                this.remainingPosInc += this.indexAnalyzer.getPositionIncrementGap(this.fieldName);
                this.startValIdx = this.endValIdx + 1;
                this.endValIdx = this.content.indexOf(this.splitChar, this.startValIdx);
                if (this.endValIdx == -1) {
                    this.endValIdx = this.content.length();
                }
                if ((tokenStream = this.indexAnalyzer.tokenStream(this.fieldName, this.content.substring(this.startValIdx, this.endValIdx))) != this.input) {
                    throw new IllegalStateException("Require TokenStream re-use.  Unsupported re-use strategy?: " + this.indexAnalyzer.getReuseStrategy());
                }
                tokenStream.reset();
            }
        }

        @Override
        public void end() throws IOException {
            super.end();
            this.offsetAtt.setOffset(this.startValIdx + this.offsetAtt.startOffset(), this.startValIdx + this.offsetAtt.endOffset());
        }
    }
}

