/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.BadMessageException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpFields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.URIUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.ExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class DelegatedServerUpgradeRequest
implements JettyServerUpgradeRequest {
    private final URI requestURI;
    private final String queryString;
    private final ServerUpgradeRequest upgradeRequest;
    private final HttpServletRequest httpServletRequest;
    private final Principal userPrincipal;
    private final Map<String, List<String>> headers;
    private List<HttpCookie> cookies;
    private Map<String, List<String>> parameterMap;

    public DelegatedServerUpgradeRequest(ServerUpgradeRequest request) {
        this.httpServletRequest = (HttpServletRequest)request.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.wrappedRequest");
        this.upgradeRequest = request;
        this.queryString = this.httpServletRequest.getQueryString();
        this.userPrincipal = this.httpServletRequest.getUserPrincipal();
        this.headers = HttpFields.asMap(this.upgradeRequest.getHeaders());
        try {
            StringBuffer uri = this.httpServletRequest.getRequestURL();
            if (this.queryString != null) {
                uri.append("?").append(this.queryString);
            }
            uri.replace(0, uri.indexOf(":"), request.isSecure() ? "wss" : "ws");
            this.requestURI = new URI(uri.toString());
        }
        catch (Throwable t2) {
            throw new BadMessageException("Bad WebSocket UpgradeRequest", t2);
        }
    }

    public ServerUpgradeRequest getServerUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public List<HttpCookie> getCookies() {
        if (this.cookies == null) {
            Cookie[] reqCookies = this.httpServletRequest.getCookies();
            this.cookies = reqCookies != null ? Arrays.stream(reqCookies).map(c -> new HttpCookie(c.getName(), c.getValue())).collect(Collectors.toList()) : Collections.emptyList();
        }
        return this.cookies;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.upgradeRequest.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    @Override
    public String getHeader(String name) {
        return this.upgradeRequest.getHeaders().get(name);
    }

    @Override
    public int getHeaderInt(String name) {
        return this.httpServletRequest.getIntHeader(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.upgradeRequest.getHeaders().getValuesList(name);
    }

    @Override
    public String getHost() {
        return this.upgradeRequest.getHttpURI().getHost();
    }

    @Override
    public String getHttpVersion() {
        return this.upgradeRequest.getConnectionMetaData().getHttpVersion().asString();
    }

    @Override
    public String getMethod() {
        return this.httpServletRequest.getMethod();
    }

    @Override
    public String getOrigin() {
        return this.httpServletRequest.getHeader(HttpHeader.ORIGIN.asString());
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        Map<String, String[]> requestParams;
        if (this.parameterMap == null && (requestParams = this.httpServletRequest.getParameterMap()) != null) {
            this.parameterMap = new HashMap<String, List<String>>(requestParams.size());
            for (Map.Entry<String, String[]> entry : requestParams.entrySet()) {
                this.parameterMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
        }
        return this.parameterMap;
    }

    @Override
    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public HttpSession getSession() {
        return this.httpServletRequest.getSession();
    }

    @Override
    public List<String> getSubProtocols() {
        return this.upgradeRequest.getSubProtocols();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public boolean hasSubProtocol(String subprotocol) {
        return this.upgradeRequest.hasSubProtocol(subprotocol);
    }

    @Override
    public boolean isSecure() {
        return this.httpServletRequest.isSecure();
    }

    @Override
    public X509Certificate[] getCertificates() {
        return (X509Certificate[])this.httpServletRequest.getAttribute("jakarta.servlet.request.X509Certificate");
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    @Override
    public Locale getLocale() {
        return this.httpServletRequest.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return this.httpServletRequest.getLocales();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.upgradeRequest.getConnectionMetaData().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.upgradeRequest.getConnectionMetaData().getRemoteSocketAddress();
    }

    @Override
    public String getRequestPath() {
        return URIUtil.addPaths(this.httpServletRequest.getServletPath(), this.httpServletRequest.getPathInfo());
    }

    @Override
    public Object getServletAttribute(String name) {
        return this.upgradeRequest.getAttribute(name);
    }

    @Override
    public Map<String, Object> getServletAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        Enumeration<String> attributeNames = this.httpServletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = attributeNames.nextElement();
            attributes.put(name, this.httpServletRequest.getAttribute(name));
        }
        return attributes;
    }

    @Override
    public Map<String, List<String>> getServletParameters() {
        return this.getParameterMap();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.httpServletRequest.isUserInRole(role);
    }

    @Override
    public void setServletAttribute(String name, Object value) {
        this.upgradeRequest.setAttribute(name, value);
    }
}

