/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreatePlacementGroupRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreatePlacementGroupRequestMarshaller
implements Marshaller<Request<CreatePlacementGroupRequest>, CreatePlacementGroupRequest> {
    @Override
    public Request<CreatePlacementGroupRequest> marshall(CreatePlacementGroupRequest createPlacementGroupRequest) {
        SdkInternalList createPlacementGroupRequestTagSpecificationsList;
        if (createPlacementGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlacementGroupRequest> request = new DefaultRequest<CreatePlacementGroupRequest>(createPlacementGroupRequest, "AmazonEC2");
        request.addParameter("Action", "CreatePlacementGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlacementGroupRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(createPlacementGroupRequest.getGroupName()));
        }
        if (createPlacementGroupRequest.getStrategy() != null) {
            request.addParameter("Strategy", StringUtils.fromString(createPlacementGroupRequest.getStrategy()));
        }
        if (createPlacementGroupRequest.getPartitionCount() != null) {
            request.addParameter("PartitionCount", StringUtils.fromInteger(createPlacementGroupRequest.getPartitionCount()));
        }
        if (!(createPlacementGroupRequestTagSpecificationsList = (SdkInternalList)createPlacementGroupRequest.getTagSpecifications()).isEmpty() || !createPlacementGroupRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createPlacementGroupRequestTagSpecificationsListValue : createPlacementGroupRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createPlacementGroupRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createPlacementGroupRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createPlacementGroupRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createPlacementGroupRequest.getSpreadLevel() != null) {
            request.addParameter("SpreadLevel", StringUtils.fromString(createPlacementGroupRequest.getSpreadLevel()));
        }
        return request;
    }
}

