/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AddIpamOperatingRegion;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyIpamRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.RemoveIpamOperatingRegion;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyIpamRequestMarshaller
implements Marshaller<Request<ModifyIpamRequest>, ModifyIpamRequest> {
    @Override
    public Request<ModifyIpamRequest> marshall(ModifyIpamRequest modifyIpamRequest) {
        SdkInternalList modifyIpamRequestRemoveOperatingRegionsList;
        SdkInternalList modifyIpamRequestAddOperatingRegionsList;
        if (modifyIpamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyIpamRequest> request = new DefaultRequest<ModifyIpamRequest>(modifyIpamRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyIpam");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIpamRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString(modifyIpamRequest.getIpamId()));
        }
        if (modifyIpamRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(modifyIpamRequest.getDescription()));
        }
        if (!(modifyIpamRequestAddOperatingRegionsList = (SdkInternalList)modifyIpamRequest.getAddOperatingRegions()).isEmpty() || !modifyIpamRequestAddOperatingRegionsList.isAutoConstruct()) {
            int addOperatingRegionsListIndex = 1;
            for (AddIpamOperatingRegion modifyIpamRequestAddOperatingRegionsListValue : modifyIpamRequestAddOperatingRegionsList) {
                if (modifyIpamRequestAddOperatingRegionsListValue.getRegionName() != null) {
                    request.addParameter("AddOperatingRegion." + addOperatingRegionsListIndex + ".RegionName", StringUtils.fromString(modifyIpamRequestAddOperatingRegionsListValue.getRegionName()));
                }
                ++addOperatingRegionsListIndex;
            }
        }
        if (!(modifyIpamRequestRemoveOperatingRegionsList = (SdkInternalList)modifyIpamRequest.getRemoveOperatingRegions()).isEmpty() || !modifyIpamRequestRemoveOperatingRegionsList.isAutoConstruct()) {
            int removeOperatingRegionsListIndex = 1;
            for (RemoveIpamOperatingRegion modifyIpamRequestRemoveOperatingRegionsListValue : modifyIpamRequestRemoveOperatingRegionsList) {
                if (modifyIpamRequestRemoveOperatingRegionsListValue.getRegionName() != null) {
                    request.addParameter("RemoveOperatingRegion." + removeOperatingRegionsListIndex + ".RegionName", StringUtils.fromString(modifyIpamRequestRemoveOperatingRegionsListValue.getRegionName()));
                }
                ++removeOperatingRegionsListIndex;
            }
        }
        if (modifyIpamRequest.getTier() != null) {
            request.addParameter("Tier", StringUtils.fromString(modifyIpamRequest.getTier()));
        }
        return request;
    }
}

