/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem;

import com.dataiku.dss.shadelibpoi.org.apache.poi.util.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndian;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LocaleUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;

public enum FileMagic {
    OLE2(-2226271756974174256L),
    OOXML(80, 75, 3, 4),
    XML(60, 63, 120, 109, 108),
    BIFF2(9, 0, 4, 0, 0, 0, 63, 0),
    BIFF3(9, 2, 6, 0, 0, 0, 63, 0),
    BIFF4({9, 4, 6, 0, 0, 0, 63, 0}, {9, 4, 6, 0, 0, 0, 0, 1}),
    MSWRITE({49, -66, 0, 0}, {50, -66, 0, 0}),
    RTF("{\\rtf"),
    PDF("%PDF"),
    HTML("<!DOCTYP", "<html", "\n\r<html", "\r\n<html", "\r<html", "\n<html", "<HTML", "\r\n<HTML", "\n\r<HTML", "\r<HTML", "\n<HTML"),
    WORD2(219, 165, 45, 0),
    JPEG({-1, -40, -1, -37}, {-1, -40, -1, -32, 63, 63, 74, 70, 73, 70, 0, 1}, {-1, -40, -1, -18}, {-1, -40, -1, -31, 63, 63, 69, 120, 105, 102, 0, 0}),
    GIF("GIF87a", "GIF89a"),
    PNG(137, 80, 78, 71, 13, 10, 26, 10),
    TIFF("II*\u0000", "MM\u0000*"),
    WMF(215, 205, 198, 154),
    EMF(1, 0, 0, 0, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 32, 69, 77, 70),
    BMP(66, 77),
    UNKNOWN(new byte[][]{new byte[0]});

    static final int MAX_PATTERN_LENGTH = 44;
    final byte[][] magic;

    private FileMagic(long magic) {
        this.magic = new byte[1][8];
        LittleEndian.putLong(this.magic[0], 0, magic);
    }

    private FileMagic(int ... magic) {
        byte[] one = new byte[magic.length];
        for (int i = 0; i < magic.length; ++i) {
            one[i] = (byte)(magic[i] & 0xFF);
        }
        this.magic = new byte[][]{one};
    }

    private FileMagic(byte[] ... magic) {
        this.magic = magic;
    }

    private FileMagic(String ... magic) {
        this.magic = new byte[magic.length][];
        int i = 0;
        for (String s : magic) {
            this.magic[i++] = s.getBytes(LocaleUtil.CHARSET_1252);
        }
    }

    public static FileMagic valueOf(byte[] magic) {
        for (FileMagic fm : FileMagic.values()) {
            for (byte[] ma : fm.magic) {
                if (magic.length < ma.length || !FileMagic.findMagic(ma, magic)) continue;
                return fm;
            }
        }
        return UNKNOWN;
    }

    private static boolean findMagic(byte[] expected, byte[] actual) {
        int i = 0;
        for (byte expectedByte : expected) {
            if (actual[i++] == expectedByte || expectedByte == 63) continue;
            return false;
        }
        return true;
    }

    public static FileMagic valueOf(File inp) throws IOException {
        try (InputStream fis = Files.newInputStream(inp.toPath(), new OpenOption[0]);){
            byte[] data = new byte[44];
            int read = IOUtils.readFully(fis, data, 0, 44);
            if (read == -1) {
                FileMagic fileMagic = UNKNOWN;
                return fileMagic;
            }
            data = Arrays.copyOf(data, read);
            FileMagic fileMagic = FileMagic.valueOf(data);
            return fileMagic;
        }
    }

    public static FileMagic valueOf(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            throw new IOException("getFileMagic() only operates on streams which support mark(int)");
        }
        byte[] data = IOUtils.peekFirstNBytes(inp, 44);
        return FileMagic.valueOf(data);
    }

    public static InputStream prepareToCheckMagic(InputStream stream) {
        if (stream.markSupported()) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }
}

