/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class URLCheckers {
    protected static final Logger LOGGER = Logging.getLogger(URLCheckers.class);
    private static FactoryRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryRegistry getServiceRegistry() {
        Class<URLChecker> clazz = URLChecker.class;
        synchronized (URLChecker.class) {
            if (registry == null) {
                registry = new FactoryCreator(URLChecker.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static synchronized void reset() {
        if (registry == null) {
            return;
        }
        registry.deregisterAll();
        registry.scanForPlugins();
    }

    public static void register(URLChecker checker) {
        URLCheckers.getServiceRegistry().registerFactory((Object)checker, URLChecker.class);
    }

    public static void deregister(URLChecker checker) {
        URLCheckers.getServiceRegistry().deregisterFactory((Object)checker, URLChecker.class);
    }

    public static List<URLChecker> getEnabledURLCheckers() {
        return URLCheckers.getServiceRegistry().getFactories(URLChecker.class, null, GeoTools.getDefaultHints()).filter(u -> u.isEnabled()).collect(Collectors.toList());
    }

    public static void confirm(URL url) throws URLCheckerException {
        URLCheckers.confirm(url.toExternalForm());
    }

    public static void confirm(URI uri) throws URLCheckerException {
        URLCheckers.confirm(uri.toString());
    }

    public static String normalize(String location) {
        block9: {
            block8: {
                if (location.indexOf(46) == -1) {
                    return location;
                }
                if (location.indexOf(58) != -1) {
                    try {
                        URI uri = new URI(location);
                        URI normal = uri.normalize();
                        if (normal.getScheme().equalsIgnoreCase("file") && normal.getHost() == null) {
                            normal = new URI(normal.getScheme(), normal.getUserInfo(), "", normal.getPort(), normal.getPath(), normal.getQuery(), normal.getFragment());
                        }
                        return normal.toString();
                    }
                    catch (URISyntaxException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block8;
                        LOGGER.fine("URI.normalize() not available for location: " + location);
                    }
                }
            }
            if (location.indexOf(47) != -1 || location.indexOf(92) != -1) {
                try {
                    Path path = Paths.get(location, new String[0]);
                    return path.normalize().toString();
                }
                catch (InvalidPathException invalid) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block9;
                    LOGGER.fine("Path.normalize() not available for location: " + location);
                }
            }
        }
        return location;
    }

    public static void confirm(String location) throws URLCheckerException {
        List<URLChecker> checkers = URLCheckers.getEnabledURLCheckers();
        if (checkers.isEmpty()) {
            return;
        }
        String normalized = URLCheckers.normalize(location);
        for (URLChecker urlChecker : checkers) {
            if (!urlChecker.confirm(normalized)) continue;
            return;
        }
        throw new URLCheckerException("Evaluation Failure: '" + location + "' was not accepted by external URL checks");
    }
}

