/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.GsonTypeAdapterUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.beans.Transient;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class Schema
implements Serializable {
    private static final long serialVersionUID = -1L;
    public boolean userModified;
    public JsonObject metadata;
    public List<SchemaColumn> columns = new ArrayList<SchemaColumn>();
    static final TypeAdapter<Schema> ADAPTER = new TypeAdapter<Schema>(){
        TypeAdapter<JsonObject> jsonObjectAdapter = new Gson().getAdapter(JsonObject.class);

        public Schema read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Schema ft = new Schema();
            in.beginObject();
            block10: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "columns": {
                        in.beginArray();
                        while (in.hasNext()) {
                            ft.columns.add((SchemaColumn)SchemaColumn.ADAPTER.read(in));
                        }
                        in.endArray();
                        continue block10;
                    }
                    case "metadata": {
                        ft.metadata = (JsonObject)this.jsonObjectAdapter.read(in);
                        continue block10;
                    }
                    case "userModified": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block10;
                        ft.userModified = in.nextBoolean();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return ft;
        }

        public void write(JsonWriter out, Schema cl) throws IOException {
            if (cl == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            if (cl.columns != null) {
                out.name("columns").beginArray();
                for (SchemaColumn cl2 : cl.columns) {
                    SchemaColumn.ADAPTER.write(out, (Object)cl2);
                }
                out.endArray();
            }
            out.name("userModified").value(cl.userModified);
            if (cl.metadata != null) {
                out.name("metadata");
                this.jsonObjectAdapter.write(out, (Object)cl.metadata);
            }
            out.endObject();
        }
    };

    public Schema() {
    }

    public Schema filter(List<String> columnNames) {
        ArrayList<SchemaColumn> filteredColumns = new ArrayList<SchemaColumn>();
        for (String columnName : columnNames) {
            SchemaColumn column = this.getColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException(String.format("The schema does not contain any column named %s", columnName));
            }
            filteredColumns.add(column);
        }
        return new Schema(filteredColumns, this.userModified);
    }

    public Schema(List<SchemaColumn> columns, boolean userModified) {
        this.columns = columns;
        this.userModified = userModified;
    }

    public Schema(Schema other) {
        if (other != null) {
            this.userModified = other.userModified;
            for (SchemaColumn col : other.columns) {
                this.columns.add(new SchemaColumn(col));
            }
            this.metadata = other.metadata != null ? (JsonObject)JSON.deepCopy((Object)other.metadata) : null;
        }
    }

    public Schema getCopy() {
        return new Schema(this);
    }

    public String prettyPrint(int indent) {
        StringBuilder sb = new StringBuilder();
        for (SchemaColumn sc : this.columns) {
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            sb.append(sc.name + " " + sc.type + "\n");
        }
        return sb.toString();
    }

    private static String quoteIdentifier(String str) {
        String quoteChar = "\"";
        return quoteChar + StringUtils.replace((String)str, (String)quoteChar, (String)(quoteChar + quoteChar)) + quoteChar;
    }

    public String compactPrettyPrint() {
        return this.columns.stream().map(c -> Schema.quoteIdentifier(c.name) + " " + c.type).collect(Collectors.joining(", "));
    }

    public void addColumn(SchemaColumn sc) {
        this.columns.add((SchemaColumn)JSON.deepCopy((Object)sc));
    }

    public void addColumns(Iterable<SchemaColumn> columns) {
        for (SchemaColumn sc : columns) {
            this.addColumn(sc);
        }
    }

    public Schema withColumn(SchemaColumn sc) {
        this.addColumn(sc);
        return this;
    }

    public void removeColumn(String name) {
        ListIterator<SchemaColumn> it = this.columns.listIterator();
        while (it.hasNext()) {
            SchemaColumn col = it.next();
            if (!name.equals(col.getName())) continue;
            it.remove();
        }
    }

    public void addColumn(String name, Type type) {
        SchemaColumn column = new SchemaColumn(name, type);
        this.columns.add(column);
    }

    public Schema withColumn(String name, Type type) {
        this.addColumn(name, type);
        return this;
    }

    public String transmogrify(String name) {
        StringTransmogrifier st = new StringTransmogrifier();
        for (SchemaColumn sc : this.columns) {
            st.addAlreadyTransmogrifiedAcceptDupes(sc.name);
        }
        return st.transmogrify(name);
    }

    @Transient
    public List<SchemaColumn> getColumns() {
        return this.columns;
    }

    @CheckForNull
    public SchemaColumn getColumn(String name) {
        for (SchemaColumn col : this.getColumns()) {
            if (!StringUtils.equals((String)col.getName(), (String)name)) continue;
            return col;
        }
        return null;
    }

    public boolean hasColumns() {
        return this.columns != null && !this.columns.isEmpty();
    }

    public boolean hasColumn(String name) {
        return this.getColumn(name) != null;
    }

    public SchemaColumn getColumnOrDefault(String name, Type defaultType) {
        SchemaColumn column = this.getColumn(name);
        if (column == null) {
            column = new SchemaColumn(name, defaultType);
        }
        return column;
    }

    public Integer getColumnIndex(String name) {
        List<SchemaColumn> cols = this.getColumns();
        for (int i = 0; i < cols.size(); ++i) {
            if (!StringUtils.equals((String)cols.get(i).getName(), (String)name)) continue;
            return i;
        }
        return null;
    }

    public void updateOrAddColumn(SchemaColumn newColumn) {
        for (int i = 0; i < this.columns.size(); ++i) {
            String name = this.columns.get(i).getName();
            if (name == null || !name.equals(newColumn.name)) continue;
            this.columns.set(i, newColumn);
            return;
        }
        this.columns.add(newColumn);
    }

    public void updateColumn(String oldName, SchemaColumn newColumn) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!oldName.equals(this.columns.get(i).getName())) continue;
            this.columns.set(i, newColumn);
            return;
        }
        assert (false) : "Could not update column " + oldName + ", not found";
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Schema:");
        for (SchemaColumn col : this.getColumns()) {
            result.append(col.getName()).append(",");
        }
        return result.toString();
    }

    public SchemaColumn asColumn() {
        SchemaColumn sc = new SchemaColumn("root", Type.OBJECT);
        sc.objectFields = this.getColumns();
        return sc;
    }

    public Schema fixup() {
        SchemaColumn fakeRootColumn = new SchemaColumn("root", Type.OBJECT);
        fakeRootColumn.objectFields = this.columns;
        Schema out = (Schema)JSON.deepCopy((Object)this);
        out.columns = fakeRootColumn.getFixedUp().objectFields;
        return out;
    }

    public static void registerAdapters() {
        JSON.registerAdapter(Schema.class, ADAPTER);
        JSON.registerAdapter(SchemaColumn.class, SchemaColumn.ADAPTER);
    }

    public void rewindTypesToV1FromRecipe(String type) {
        if ("python".equals(type)) {
            this.rewindTypesToV1FromOrigin("python");
        }
        if (type != null && type.contains("spark")) {
            this.rewindTypesToV1FromOrigin("spark");
        }
    }

    public void rewindTypesToV1FromOrigin(String origin) {
        block8: {
            block9: {
                block7: {
                    if (origin == null) {
                        return;
                    }
                    if (!origin.equals("python")) break block7;
                    for (SchemaColumn sc : this.columns) {
                        if (sc.getType() == Type.DATEONLY) {
                            sc.setType(Type.DATE);
                            continue;
                        }
                        if (sc.getType() != Type.DATETIMENOTZ) continue;
                        sc.setType(Type.DATE);
                    }
                    break block8;
                }
                if (!origin.equals("sparklike")) break block9;
                for (SchemaColumn sc : this.columns) {
                    if (sc.getType() == Type.DATEONLY) {
                        sc.setType(Type.STRING);
                        continue;
                    }
                    if (sc.getType() != Type.DATETIMENOTZ) continue;
                    sc.setType(Type.DATE);
                }
                break block8;
            }
            if (!origin.equals("spark")) break block8;
            for (SchemaColumn sc : this.columns) {
                if (sc.getType() == Type.DATEONLY) {
                    sc.setType(Type.DATE);
                    continue;
                }
                if (sc.getType() != Type.DATETIMENOTZ) continue;
                sc.setType(Type.STRING);
            }
        }
    }
}

