/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FSBrowsePath {
    public boolean truncated;
    public String name;
    public String fullPath;
    public List<String> pathElts = Lists.newArrayList();
    public boolean exists;
    public boolean directory;
    public long size;
    public long lastModified;
    public List<FSBrowsePath> children = Lists.newArrayList();

    public static FSBrowsePath makeChild(String relPath, List<String> ancestors, String fullPath, boolean directory, long size, long lastModified, boolean useRelativePaths) {
        FSBrowsePath child = new FSBrowsePath();
        child.name = relPath;
        child.exists = true;
        child.pathElts.addAll(ancestors);
        child.pathElts.add(relPath);
        child.fullPath = useRelativePaths ? (fullPath.startsWith("/") ? fullPath.substring(1) : fullPath) : (fullPath.startsWith("/") ? fullPath : "/" + fullPath);
        child.directory = directory;
        if (!directory) {
            child.size = size;
        }
        child.lastModified = lastModified;
        return child;
    }

    public static FSBrowsePath makeChild(FSBrowsePath parent, String relPath, boolean directory, long size, long lastModified) {
        FSBrowsePath child = new FSBrowsePath();
        child.name = relPath;
        child.exists = true;
        child.pathElts.addAll(parent.pathElts);
        child.pathElts.add(relPath);
        child.fullPath = parent.fullPath + (parent.fullPath.endsWith("/") ? "" : "/") + relPath;
        child.directory = directory;
        if (!directory) {
            child.size = size;
        }
        child.lastModified = lastModified;
        return child;
    }

    public static FSBrowsePath makeElement(String prefix, boolean directory, long size, long lastModified, boolean useRelativePaths) {
        FSBrowsePath ret = new FSBrowsePath();
        ret.fullPath = useRelativePaths ? (prefix.startsWith("/") ? prefix.substring(1) : prefix) : (prefix.startsWith("/") ? prefix : "/" + prefix);
        ret.exists = true;
        ret.splitFullPath(useRelativePaths);
        ret.directory = directory;
        if (!directory) {
            ret.size = size;
            ret.lastModified = lastModified;
        }
        return ret;
    }

    public static FSBrowsePath makeRoot(String prefix, boolean useRelativePaths) {
        FSBrowsePath ret = new FSBrowsePath();
        ret.fullPath = useRelativePaths ? (prefix.startsWith("/") ? prefix.substring(1) : prefix) : (prefix.startsWith("/") ? prefix : "/" + prefix);
        ret.exists = true;
        ret.directory = false;
        ret.splitFullPath(useRelativePaths);
        return ret;
    }

    private void splitFullPath(boolean useRelativePaths) {
        if (StringUtils.isNotBlank((String)this.fullPath)) {
            String[] split;
            for (String chunk : split = this.fullPath.split("/+")) {
                this.pathElts.add(chunk);
            }
            if (split.length == 0 && !this.fullPath.isEmpty()) {
                this.pathElts.add("");
                this.name = null;
            } else {
                this.name = this.pathElts.size() > 0 ? this.pathElts.get(this.pathElts.size() - 1) : null;
            }
        }
    }

    public void sortChildrenAlphabetically() {
        Collections.sort(this.children, new Comparator<FSBrowsePath>(){

            @Override
            public int compare(FSBrowsePath a, FSBrowsePath b) {
                String aPath = Joiner.on((String)"/").join(a.pathElts);
                String bPath = Joiner.on((String)"/").join(b.pathElts);
                return aPath.compareTo(bPath);
            }
        });
    }

    public static FSBrowsePath browse(String rootPath, String relativePath, boolean withDirectoriesSize) throws IOException, DKUSecurityException {
        File rootFile = new File(rootPath);
        String normalizedRelativePath = PathUtils.slashes((String)PathUtils.canonical((String)relativePath), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        File fileToBrowse = "/".equals(normalizedRelativePath) ? rootFile : new File(rootFile, normalizedRelativePath);
        FSBrowsePath.checkFileStaysInsideRoot(rootFile, fileToBrowse);
        FSBrowsePath ret = FSBrowsePath.makeRoot(normalizedRelativePath, false);
        if (!fileToBrowse.exists()) {
            ret.exists = false;
            return ret;
        }
        if (fileToBrowse.isDirectory()) {
            ret.directory = true;
            File[] subFiles = fileToBrowse.listFiles();
            if (subFiles != null) {
                for (File f : subFiles) {
                    if (!FSBrowsePath.isValidChunk(f.getName())) continue;
                    FSBrowsePath child = FSBrowsePath.makeChild(ret, f.getName(), f.isDirectory(), f.length(), f.lastModified());
                    if (f.isDirectory() && withDirectoriesSize) {
                        child.size = FileUtils.sizeOfDirectory((File)f);
                    }
                    ret.children.add(child);
                }
            }
            if (withDirectoriesSize) {
                ret.size = FileUtils.sizeOfDirectory((File)fileToBrowse);
            }
        } else {
            ret.directory = false;
            ret.size = fileToBrowse.length();
            ret.lastModified = fileToBrowse.lastModified();
        }
        return ret;
    }

    private static void checkFileStaysInsideRoot(File root, File file) throws IOException, DKUSecurityException {
        if (!DKUFileUtils.isWithinOrSame((File)root, (File)file)) {
            throw new DKUSecurityException("Cannot access '" + file.getAbsolutePath() + "' outside the root directory");
        }
    }

    private static boolean isValidChunk(String chunk) {
        return !chunk.isEmpty() && !".".equals(chunk) && (DKUtils.isOsWindows() || !chunk.startsWith("."));
    }
}

