(function() {
'use strict';
const app = angular.module('dataiku.agentdependencies', ['dataiku.services', 'dataiku.filters']);

app.directive('dependencyComponent', function() {
    return {
        restrict: 'E',
        scope: {
            currentDependencies: '=',
            addDependency: '&',
            description: '@',
            removeDependency: '&',
            warningMsg: '<'
        },
        controllerAs: '$ctrl',
        bindToController: true,
        templateUrl: 'templates/agent-tools/dependencies-component.html',
        controller: function($scope, $window, DatasetUtils, CreateModalFromTemplate, FLOW_COMPUTABLE_DEPENDENCIES, $stateParams, DataikuAPI, CatalogRefreshUtils) {
            const $ctrl = this;

            $ctrl.computeDependencyLink = function(dependency) {
                dependency.name = dependency.id;
                if (dependency.type === "DATASET") {
                    dependency.datasetFullName = dependency.projectKey + "." + dependency.name;
                }
                return CatalogRefreshUtils.getLinkForElement($stateParams.projectKey, dependency);
            };

            $ctrl.isForeignObject = function(dependency) {
                return dependency.projectKey !== $stateParams.projectKey;
            };

            $ctrl.openModalForm = function() {
                CreateModalFromTemplate("/templates/agent-tools/add-editor-dss-dependency-modal.html", $scope, null, function(modalScope) {
                    modalScope.acceptedTypes = FLOW_COMPUTABLE_DEPENDENCIES
                    modalScope.confirm = (selectedDependency) => modalScope.resolveModal(selectedDependency);
                    modalScope.cancel = () => modalScope.dismiss();
                }).then((selectedDependency) => {
                    $ctrl.addDependency({ dependencyToAdd: selectedDependency });
                })
            };
        }
    };
});

app.controller('AddDependenciesDSSObjectModalController', function($scope, $stateParams) {
    $scope.newReference = {
        projectKey: $stateParams.projectKey
    };

    $scope.uiState = {
        selectedObject: {},
    };
});
})();
