(function() {
    'use strict';

    window.dkuDragType = (
        window.navigator.userAgent.indexOf('Trident') >= 0) ? 'Text' :
        (window.navigator.userAgent.indexOf('Edge') >= 0 ? 'text/plain' : 'json');

    const app = angular.module('dataiku.directives.simple_report');

    /**
     * Container required for common logic of drag and drop directives (from simple_report/directives/drag-drop/).
     * This code previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     */
    app.controller('ChartDragDropController', ($scope) => {

        $scope.setDragActive = () => {
            $('.chart-configuration-wrapper').addClass('drag-active');
        };

        $scope.setDragInactive = () => {
            $('.chart-configuration-wrapper').removeClass('drag-active');
        };

        $scope.addClassHereAndThere = (element, clazz) => {
            $(element).addClass(clazz);
            $(element).parent().parent().addClass(clazz);
        };

        $scope.removeClassHereAndThere = (element, clazz) => {
            $(element).removeClass(clazz);
            $(element).parent().parent().removeClass(clazz);
        };
    });

})();
